/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.common;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.logging.common.spi.MdcProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public class HelidonMdc {
    private static final List<MdcProvider> MDC_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(MdcProvider.class)).build().asList();

    private HelidonMdc() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static void set(String key, String value) {
        MDC_PROVIDERS.forEach(provider -> provider.put(key, value));
    }

    public static void remove(String key) {
        MDC_PROVIDERS.forEach(provider -> provider.remove(key));
    }

    public static void clear() {
        MDC_PROVIDERS.forEach(MdcProvider::clear);
    }

    public static Optional<String> get(String key) {
        return MDC_PROVIDERS.stream().map(provider -> provider.get(key)).filter(Objects::nonNull).findFirst();
    }
}

