/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;

class JavaMethodFinder {
    private JavaMethodFinder() {
    }

    static Method findMethod(Class<?> clazz, String methodName, Type[] paramTypes) throws NoSuchMethodException {
        int mod;
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        queue.add(clazz);
        Method method = null;
        Class current = null;
        while (!queue.isEmpty() && method == null) {
            Method[] methods;
            current = (Class)queue.remove();
            for (Method m : methods = current.getDeclaredMethods()) {
                Type[] leftParamTypes = m.getGenericParameterTypes();
                if (!m.getName().equals(methodName) || !JavaMethodFinder.isCompatible(leftParamTypes, paramTypes)) continue;
                method = m;
                break;
            }
            if (method != null || current.getSuperclass() == null) continue;
            queue.add(current.getSuperclass());
            Arrays.stream(current.getInterfaces()).forEach(queue::add);
        }
        if (method == null) {
            throw new NoSuchMethodException();
        }
        if (!(current == clazz || Modifier.isPublic(mod = method.getModifiers()) || Modifier.isProtected(mod) || !Modifier.isPrivate(mod) && current.getPackage().equals(clazz.getPackage()))) {
            throw new NoSuchMethodException();
        }
        method.setAccessible(true);
        return method;
    }

    private static boolean isCompatible(Type[] leftArray, Type[] rightArray) {
        if (leftArray.length == rightArray.length) {
            int i;
            for (i = 0; i < leftArray.length && JavaMethodFinder.isCompatible(leftArray[i], rightArray[i]); ++i) {
            }
            if (i == leftArray.length) {
                return true;
            }
        }
        return false;
    }

    private static boolean isCompatible(Type left, Type right) {
        if (left.equals(right)) {
            return true;
        }
        if (left instanceof TypeVariable && !(right instanceof TypeVariable)) {
            return true;
        }
        if (left instanceof WildcardType && right instanceof WildcardType) {
            WildcardType wleft = (WildcardType)left;
            WildcardType wright = (WildcardType)((Object)right);
            if (JavaMethodFinder.isCompatible(wleft.getUpperBounds(), wright.getUpperBounds()) && JavaMethodFinder.isCompatible(wleft.getLowerBounds(), wright.getLowerBounds())) {
                return true;
            }
        }
        if (left instanceof GenericArrayType && right instanceof Class) {
            Type tleft = left;
            Class<?> tright = right;
            try {
                do {
                    tleft = ((GenericArrayType)tleft).getGenericComponentType();
                    tright = ((Class)tright).getComponentType();
                } while (tleft instanceof GenericArrayType);
                if (tright != null && JavaMethodFinder.isCompatible(tleft, tright)) {
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (left instanceof ParameterizedType && right instanceof ParameterizedType) {
            ParameterizedType pleft = (ParameterizedType)left;
            ParameterizedType pright = (ParameterizedType)((Object)right);
            return pleft.getRawType().equals(pright.getRawType()) && JavaMethodFinder.isCompatible(pleft.getActualTypeArguments(), pright.getActualTypeArguments());
        }
        try {
            return ((Class)left).isAssignableFrom(right);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

