/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.FaultToleranceParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class MethodAntn {
    private static final Logger LOGGER = Logger.getLogger(MethodAntn.class.getName());
    private final Method method;
    private final Class<?> beanClass;

    MethodAntn(Class<?> beanClass, Method method) {
        this.beanClass = beanClass;
        this.method = method;
    }

    Method method() {
        return this.method;
    }

    Class<?> beanClass() {
        return this.beanClass;
    }

    public final <A extends Annotation> LookupResult<A> lookupAnnotation(Class<A> annotClass) {
        return MethodAntn.lookupAnnotation(this.beanClass, this.method, annotClass);
    }

    static <A extends Annotation> LookupResult<A> lookupAnnotation(Class<?> beanClass, Method method, Class<A> annotClass) {
        A annotation = method.getAnnotation(annotClass);
        if (annotation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found annotation '" + annotClass.getName() + "' method '" + method.getName() + "'");
            }
            return new LookupResult<A>(MatchingType.METHOD, annotation);
        }
        annotation = beanClass.getAnnotation(annotClass);
        if (annotation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found annotation '" + annotClass.getName() + "' class '" + method.getDeclaringClass().getName() + "'");
            }
            return new LookupResult<A>(MatchingType.CLASS, annotation);
        }
        annotation = method.getDeclaringClass().getAnnotation(annotClass);
        if (annotation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found annotation '" + method.getDeclaringClass().getName() + "' class '" + method.getDeclaringClass().getName() + "'");
            }
            return new LookupResult<A>(MatchingType.CLASS, annotation);
        }
        return null;
    }

    static boolean isAnnotationPresent(Class<?> beanClass, Method method, Class<? extends Annotation> annotClass) {
        return MethodAntn.lookupAnnotation(beanClass, method, annotClass) != null;
    }

    public abstract void validate();

    public Class<? extends Annotation> annotationType() {
        return this.getClass().getInterfaces()[0];
    }

    protected String getParamOverride(String parameter, MatchingType type) {
        String value;
        String annotationType = this.getClass().getInterfaces()[0].getSimpleName();
        if (type == MatchingType.METHOD ? (value = FaultToleranceParameter.getParameter(this.method.getDeclaringClass().getName(), this.method.getName(), annotationType, parameter)) != null : type == MatchingType.CLASS && (value = FaultToleranceParameter.getParameter(this.method.getDeclaringClass().getName(), annotationType, parameter)) != null) {
            return value;
        }
        value = FaultToleranceParameter.getParameter(annotationType, parameter);
        if (value != null) {
            return value;
        }
        return null;
    }

    static Class<? extends Throwable>[] parseThrowableArray(String array) {
        ArrayList result = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(array, "{}, \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            try {
                String className = tokenizer.nextToken();
                if (className.endsWith(".class")) {
                    className = className.substring(0, className.length() - ".class".length());
                }
                result.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result.toArray(new Class[0]);
    }

    static class LookupResult<A extends Annotation> {
        private final MatchingType type;
        private final A annotation;

        LookupResult(MatchingType type, A annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public MatchingType getType() {
            return this.type;
        }

        public A getAnnotation() {
            return this.annotation;
        }
    }

    static enum MatchingType {
        METHOD,
        CLASS;

    }
}

