/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.FtSupplier;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.CDI;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.weld.se.WeldRequestScope;
import org.jboss.weld.context.WeldAlterableContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.bound.BoundLiteral;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.manager.api.WeldManager;

class RequestScopeHelper {
    private State state = State.CLEARED;
    private RequestScope requestScope;
    private RequestContext requestContext;
    private InjectionManager injectionManager;
    private WeldManager weldManager;
    private Collection<ContextualInstance<?>> requestScopeInstances;

    RequestScopeHelper() {
    }

    void saveScope() {
        if (this.state == State.STORED) {
            throw new IllegalStateException("Request scope state already stored");
        }
        this.weldManager = (WeldManager)CDI.current().select(WeldManager.class, new Annotation[0]).get();
        if (this.weldManager != null) {
            for (WeldAlterableContext context : this.weldManager.getActiveWeldAlterableContexts()) {
                if (context.getScope() != RequestScoped.class) continue;
                this.requestScopeInstances = context.getAllContextualInstances();
            }
        }
        this.injectionManager = (InjectionManager)WeldRequestScope.actualInjectorManager.get();
        try {
            this.requestScope = (RequestScope)CDI.current().select(RequestScope.class, new Annotation[0]).get();
            this.requestContext = this.requestScope.referenceCurrent();
        }
        catch (Exception exception) {
        }
        finally {
            this.state = State.STORED;
        }
    }

    FtSupplier<Object> wrapInScope(FtSupplier<Object> supplier) {
        if (this.state != State.STORED) {
            throw new IllegalStateException("Request scope state never stored");
        }
        if (this.requestScope != null && this.requestContext != null) {
            return () -> this.requestScope.runInScope(this.requestContext, () -> {
                InjectionManager old = (InjectionManager)WeldRequestScope.actualInjectorManager.get();
                BoundRequestContext boundRequestContext = null;
                try {
                    boundRequestContext = this.migrateRequestContext();
                    WeldRequestScope.actualInjectorManager.set(this.injectionManager);
                    Object t = supplier.get();
                    return t;
                }
                catch (Throwable t) {
                    throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
                }
                finally {
                    if (boundRequestContext != null) {
                        boundRequestContext.deactivate();
                    }
                    WeldRequestScope.actualInjectorManager.set(old);
                }
            });
        }
        if (this.weldManager != null) {
            return () -> {
                BoundRequestContext boundRequestContext = null;
                try {
                    boundRequestContext = this.migrateRequestContext();
                    Object t = supplier.get();
                    return t;
                }
                finally {
                    if (boundRequestContext != null) {
                        boundRequestContext.deactivate();
                    }
                }
            };
        }
        return supplier;
    }

    private BoundRequestContext migrateRequestContext() {
        if (this.requestScopeInstances != null) {
            BoundRequestContext requestContext = (BoundRequestContext)this.weldManager.instance().select(BoundRequestContext.class, new Annotation[]{BoundLiteral.INSTANCE}).get();
            HashMap requestMap = new HashMap();
            requestContext.associate(requestMap);
            requestContext.activate();
            requestContext.clearAndSet(this.requestScopeInstances);
            return requestContext;
        }
        return null;
    }

    void clearScope() {
        if (this.requestContext != null) {
            this.requestContext.release();
            this.requestContext = null;
        }
        if (this.requestScope != null) {
            CDI.current().destroy((Object)this.requestScope);
            this.requestScope = null;
        }
        this.injectionManager = null;
        if (this.requestScopeInstances != null) {
            this.requestScopeInstances.clear();
            this.requestScopeInstances = null;
        }
        this.weldManager = null;
        this.state = State.CLEARED;
    }

    static enum State {
        CLEARED,
        STORED;

    }
}

