/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.faulttolerance.BulkheadException;
import io.helidon.faulttolerance.CircuitBreakerOpenException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

class ThrowableMapper {
    private ThrowableMapper() {
    }

    static Throwable map(Throwable t) {
        if (t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof CircuitBreakerOpenException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException(t.getMessage(), t.getCause());
        }
        if (t instanceof BulkheadException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException(t.getMessage(), t.getCause());
        }
        if (t instanceof TimeoutException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException(t.getMessage(), t.getCause());
        }
        if (t instanceof InterruptedException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException(t.getMessage(), t.getCause());
        }
        return t;
    }

    static Class<? extends Throwable>[] mapTypes(Class<? extends Throwable>[] types) {
        if (types.length == 0) {
            return types;
        }
        Class<? extends Throwable>[] result = Arrays.copyOf(types, types.length);
        for (int i = 0; i < types.length; ++i) {
            Class<? extends Throwable> t = types[i];
            result[i] = t == org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException.class ? BulkheadException.class : (t == org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException.class ? CircuitBreakerOpenException.class : (t == org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class ? TimeoutException.class : t));
        }
        return result;
    }
}

