/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.CommandBinding;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.MethodInvoker;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.logging.Logger;

@Interceptor
@CommandBinding
@Priority(value=4010)
class CommandInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CommandInterceptor.class.getName());
    private static final String INVOCATION_CONTEXT_KEY = "org.glassfish.jersey.microprofile.restclient.InterceptorInvocationContext";

    CommandInterceptor() {
    }

    @AroundInvoke
    public Object interceptCommand(InvocationContext context) throws Throwable {
        try {
            LOGGER.fine(() -> "Interceptor called for '" + context.getTarget().getClass() + "::" + context.getMethod().getName() + "'");
            MethodIntrospector introspector = new MethodIntrospector(context.getTarget().getClass(), context.getMethod());
            if (introspector.isAsynchronous() && context.getContextData().containsKey(INVOCATION_CONTEXT_KEY)) {
                InvocationContext override = (InvocationContext)context.getContextData().get(INVOCATION_CONTEXT_KEY);
                LOGGER.fine(() -> "Overriding invocation context from map " + override);
                MethodInvoker runner = new MethodInvoker(override, introspector);
                return runner.get();
            }
            MethodInvoker runner = new MethodInvoker(context, introspector);
            return runner.get();
        }
        catch (Throwable t) {
            LOGGER.fine(() -> "Throwable caught by interceptor '" + t.getMessage() + "'");
            throw t;
        }
    }
}

