/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.microprofile.jwt.auth.ClaimValueWrapper;
import io.helidon.microprofile.jwt.auth.Impl;
import io.helidon.microprofile.jwt.auth.JsonWebTokenImpl;
import io.helidon.microprofile.jwt.auth.JwtAuthCdiExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;

class ClaimProducer
implements Bean<Object> {
    private static final Annotation QUALIFIER = new Claim(){

        public String value() {
            return "";
        }

        public Claims standard() {
            return Claims.UNKNOWN;
        }

        public Class<? extends Annotation> annotationType() {
            return Claim.class;
        }
    };
    private final JwtAuthCdiExtension.MpClaimQualifier qualifier;
    private final Type type;
    private final BeanManager bm;

    ClaimProducer(JwtAuthCdiExtension.MpClaimQualifier q, Type type, BeanManager bm) {
        ParameterizedType paramType;
        this.qualifier = q;
        this.bm = bm;
        Type actualType = type;
        if (type instanceof ParameterizedType && Provider.class.equals((Object)(paramType = (ParameterizedType)type).getRawType())) {
            actualType = paramType.getActualTypeArguments()[0];
        }
        this.type = actualType;
    }

    static Object getClaimValue(String claimName, JsonWebTokenImpl webToken, JwtAuthCdiExtension.MpClaimQualifier q) {
        return ClaimProducer.getParametrizedClaimValue(claimName, webToken, q);
    }

    static Object getParametrizedClaimValue(String claimName, JsonWebTokenImpl webToken, JwtAuthCdiExtension.MpClaimQualifier claimLiteral) {
        if (null == webToken) {
            return null;
        }
        Object result = claimLiteral.claimValue() ? (claimLiteral.optional() ? webToken.getClaim(claimName, claimLiteral.typeArg2()) : webToken.getClaim(claimName, claimLiteral.typeArg())) : (claimLiteral.optional() ? webToken.getClaim(claimName, claimLiteral.typeArg()) : webToken.getClaim(claimName, claimLiteral.rawType()));
        if (claimLiteral.optional()) {
            result = Optional.ofNullable(result);
        }
        if (claimLiteral.claimValue()) {
            result = new ClaimValueWrapper(claimName, result);
        }
        return result;
    }

    public Object create(CreationalContext<Object> context) {
        return this.getClaimValue(context);
    }

    private Object getClaimValue(CreationalContext<Object> context) {
        JsonWebTokenImpl token = (JsonWebTokenImpl)CDI.current().select(JsonWebTokenImpl.class, new Annotation[]{new Impl(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Impl.class;
            }
        }}).get();
        return ClaimProducer.getClaimValue(this.qualifier.name(), token, this.qualifier);
    }

    public Class<?> getBeanClass() {
        return ClaimProducer.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Set.of();
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Set.of(this.type);
    }

    public Set<Annotation> getQualifiers() {
        return Set.of(this.qualifier, QUALIFIER);
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return this.qualifier.id();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Set.of();
    }

    public boolean isAlternative() {
        return false;
    }

    public String toString() {
        return "ClaimProducer{qualifier=" + this.qualifier + "}";
    }
}

