/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.security.Principal;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.util.AbacSupport;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public final class JsonWebTokenImpl
implements JsonWebToken,
Principal {
    private final Jwt jwt;
    private final SignedJwt signed;
    private final String id;
    private final AbacSupport properties;
    private final String name;

    private JsonWebTokenImpl(SignedJwt signed) {
        this.jwt = signed.getJwt();
        this.signed = signed;
        AbacSupport.BasicAttributes container = AbacSupport.BasicAttributes.create();
        this.jwt.payloadClaims().forEach((key, jsonValue) -> container.put(key, JwtUtil.toObject((JsonValue)jsonValue)));
        this.jwt.email().ifPresent(value -> container.put("email", value));
        this.jwt.emailVerified().ifPresent(value -> container.put("email_verified", value));
        this.jwt.locale().ifPresent(value -> container.put("locale", value));
        this.jwt.familyName().ifPresent(value -> container.put("family_name", value));
        this.jwt.givenName().ifPresent(value -> container.put("given_name", value));
        this.jwt.fullName().ifPresent(value -> container.put("full_name", value));
        this.properties = container;
        String subject = (String)this.jwt.subject().orElseThrow(() -> new JwtException("JWT does not contain subject claim, cannot create principal."));
        this.name = this.jwt.userPrincipal().or(() -> ((Jwt)this.jwt).preferredUsername()).orElse(subject);
        this.id = subject;
    }

    static JsonWebTokenImpl create(SignedJwt signed) {
        return new JsonWebTokenImpl(signed);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getClaimNames() {
        return this.jwt.payloadClaims().keySet();
    }

    public <T> T getClaim(String claimName) {
        try {
            return (T)this.getClaim(Claims.valueOf((String)claimName));
        }
        catch (IllegalArgumentException e) {
            return this.getJsonValue(claimName).orElse(null);
        }
    }

    public <T> T getClaim(String claimName, Class<T> clazz) {
        try {
            Claims claims = Claims.valueOf((String)claimName);
            return (T)(JsonValue.class.isAssignableFrom(clazz) ? this.getJsonValue(claimName).orElse(null) : this.getClaim(claims));
        }
        catch (IllegalArgumentException ignored) {
            Object value = this.getJsonValue(claimName).orElse(null);
            if (value != null && clazz != ClaimValue.class && clazz != Optional.class && !clazz.isAssignableFrom(value.getClass())) {
                throw new SecurityException("Cannot set instance of " + value.getClass().getName() + " to the field of type " + clazz.getName());
            }
            return (T)value;
        }
    }

    private Object getClaim(Claims claims) {
        switch (claims) {
            case raw_token: {
                return this.signed.tokenContent();
            }
            case groups: {
                return this.jwt.userGroups().map(HashSet::new).orElse(null);
            }
            case aud: {
                return this.jwt.audience().map(HashSet::new).orElse(null);
            }
            case email_verified: {
                return this.jwt.emailVerified().orElse(null);
            }
            case phone_number_verified: {
                return this.jwt.phoneNumberVerified().orElse(null);
            }
            case upn: {
                return this.jwt.userPrincipal().orElse(null);
            }
        }
        String claimName = claims.name();
        Optional<JsonValue> json = this.getJsonValue(claimName);
        return json.map(value -> this.convert(claims, (JsonValue)value)).orElse(null);
    }

    private Optional<JsonValue> getJsonValue(String claimName) {
        if (Claims.raw_token.name().equals(claimName)) {
            return Optional.of(Json.createValue((String)this.signed.tokenContent()));
        }
        return this.jwt.payloadClaim(claimName).or(() -> this.jwt.headerClaim(claimName));
    }

    private Object convert(Claims claims, JsonValue value) {
        Class claimClass = claims.getType();
        if (claimClass.equals(String.class) && value instanceof JsonString) {
            return ((JsonString)value).getString();
        }
        if (claimClass.equals(Long.class)) {
            if (value instanceof JsonNumber) {
                return ((JsonNumber)value).longValue();
            }
            if (value instanceof JsonString) {
                return Long.parseLong(((JsonString)value).getString());
            }
            return Long.parseLong(value.toString());
        }
        if (claimClass.equals(JsonObject.class)) {
            return value;
        }
        if (value instanceof JsonString) {
            return ((JsonString)value).getString();
        }
        return value;
    }

    public Object abacAttributeRaw(String key) {
        return this.properties.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.properties.abacAttributeNames();
    }

    public String id() {
        return this.id;
    }
}

