/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.common.Errors;
import io.helidon.common.configurable.Resource;
import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import io.helidon.microprofile.jwt.auth.JsonWebTokenImpl;
import io.helidon.microprofile.jwt.auth.JwtAuthAnnotationAnalyzer;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.Security;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityLevel;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.jwt.jwk.Jwk;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.jwt.jwk.JwkRSA;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.common.TokenCredential;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import io.helidon.security.util.TokenHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.spi.DeploymentException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import org.eclipse.microprofile.auth.LoginConfig;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JwtAuthProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    private static final Logger LOGGER = Logger.getLogger(JwtAuthProvider.class.getName());
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());
    public static final String EP_PROPERTY_OUTBOUND_USER = "io.helidon.security.outbound.user";
    public static final String CONFIG_EXPECTED_ISSUER = "mp.jwt.verify.issuer";
    private final boolean optional;
    private final boolean authenticate;
    private final boolean propagate;
    private final boolean allowImpersonation;
    private final SubjectType subjectType;
    private final TokenHandler atnTokenHandler;
    private final TokenHandler defaultTokenHandler;
    private final JwkKeys verifyKeys;
    private final String expectedAudience;
    private final JwkKeys signKeys;
    private final OutboundConfig outboundConfig;
    private final String issuer;
    private final Jwk defaultJwk;
    private final Map<OutboundTarget, JwtOutboundTarget> targetToJwtConfig = new IdentityHashMap<OutboundTarget, JwtOutboundTarget>();
    private final String expectedIssuer;

    private JwtAuthProvider(Builder builder) {
        this.optional = builder.optional;
        this.authenticate = builder.authenticate;
        this.propagate = builder.propagate;
        this.allowImpersonation = builder.allowImpersonation;
        this.subjectType = builder.subjectType;
        this.atnTokenHandler = builder.atnTokenHandler;
        this.outboundConfig = builder.outboundConfig;
        this.verifyKeys = builder.verifyKeys;
        this.signKeys = builder.signKeys;
        this.issuer = builder.issuer;
        this.expectedAudience = builder.expectedAudience;
        this.defaultJwk = builder.defaultJwk;
        this.expectedIssuer = builder.expectedIssuer;
        this.defaultTokenHandler = null == this.atnTokenHandler ? TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build() : this.atnTokenHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwtAuthProvider create(Config config) {
        return JwtAuthProvider.builder().config(config).build();
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(LoginConfig.class);
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        if (!this.authenticate) {
            return AuthenticationResponse.abstain();
        }
        List loginConfigs = ((SecurityLevel)providerRequest.endpointConfig().securityLevels().get(0)).filterAnnotations(LoginConfig.class, EndpointConfig.AnnotationScope.CLASS);
        try {
            return loginConfigs.stream().filter(JwtAuthAnnotationAnalyzer::isMpJwt).findFirst().map(loginConfig -> this.authenticate(providerRequest, (LoginConfig)loginConfig)).orElseGet(AuthenticationResponse::abstain);
        }
        catch (java.lang.SecurityException e) {
            return AuthenticationResponse.failed((String)"Failed to process authentication header", (Throwable)e);
        }
    }

    AuthenticationResponse authenticate(ProviderRequest providerRequest, LoginConfig loginConfig) {
        Optional maybeToken;
        try {
            maybeToken = this.atnTokenHandler.extractToken(providerRequest.env().headers());
        }
        catch (Exception e) {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"Header not available or in a wrong format", (Throwable)e);
        }
        return maybeToken.map(token -> {
            SignedJwt signedJwt;
            try {
                signedJwt = SignedJwt.parseToken((String)token);
            }
            catch (Exception e) {
                return AuthenticationResponse.failed((String)"Invalid token", (Throwable)e);
            }
            Errors errors = signedJwt.verifySignature(this.verifyKeys, this.defaultJwk);
            if (errors.isValid()) {
                Jwt jwt = signedJwt.getJwt();
                Errors validate = jwt.validate(this.expectedIssuer, this.expectedAudience);
                if (validate.isValid()) {
                    return AuthenticationResponse.success((Subject)this.buildSubject(jwt, signedJwt));
                }
                return AuthenticationResponse.failed((String)("Audience is invalid or missing: " + this.expectedAudience));
            }
            return AuthenticationResponse.failed((String)errors.toString());
        }).orElseGet(() -> {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"Header not available or in a wrong format");
        });
    }

    Subject buildSubject(Jwt jwt, SignedJwt signedJwt) {
        JsonWebTokenImpl principal = this.buildPrincipal(jwt, signedJwt);
        TokenCredential.Builder builder = TokenCredential.builder();
        jwt.issueTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issueTime(arg_0));
        jwt.expirationTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).expTime(arg_0));
        jwt.issuer().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issuer(arg_0));
        builder.token(signedJwt.tokenContent());
        builder.addToken(JsonWebToken.class, (Object)principal);
        builder.addToken(Jwt.class, (Object)jwt);
        builder.addToken(SignedJwt.class, (Object)signedJwt);
        Subject.Builder subjectBuilder = Subject.builder().principal((Principal)principal).addPublicCredential(TokenCredential.class, (Object)builder.build());
        Optional userGroups = jwt.userGroups();
        userGroups.ifPresent(groups -> groups.forEach(group -> subjectBuilder.addGrant((Grant)Role.create((String)group))));
        Optional scopes = jwt.scopes();
        scopes.ifPresent(scopeList -> scopeList.forEach(scope -> subjectBuilder.addGrant(Grant.builder().name(scope).type("scope").build())));
        return subjectBuilder.build();
    }

    JsonWebTokenImpl buildPrincipal(Jwt jwt, SignedJwt signedJwt) {
        return JsonWebTokenImpl.create(signedJwt);
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.propagate;
    }

    public OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Optional maybeUsername = outboundEndpointConfig.abacAttribute(EP_PROPERTY_OUTBOUND_USER);
        return maybeUsername.map(String::valueOf).flatMap(username -> {
            if (!this.allowImpersonation) {
                return Optional.of(((OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().description("Attempting to impersonate a user, when impersonation is not allowed for JWT provider")).status(SecurityResponse.SecurityStatus.FAILURE)).build());
            }
            Optional maybeTarget = this.outboundConfig.findTarget(outboundEnv);
            return maybeTarget.flatMap(target -> {
                JwtOutboundTarget jwtOutboundTarget = this.targetToJwtConfig.computeIfAbsent((OutboundTarget)target, this::toOutboundTarget);
                if (null == jwtOutboundTarget.jwkKid) {
                    return Optional.of(((OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().description("Cannot do explicit user propagation if no kid is defined.")).status(SecurityResponse.SecurityStatus.FAILURE)).build());
                }
                return Optional.of(this.impersonate(jwtOutboundTarget, (String)username));
            });
        }).orElseGet(() -> {
            Optional maybeSubject = this.subjectType == SubjectType.USER ? providerRequest.securityContext().user() : providerRequest.securityContext().service();
            return maybeSubject.flatMap(subject -> {
                Optional maybeTarget = this.outboundConfig.findTarget(outboundEnv);
                return maybeTarget.flatMap(target -> {
                    JwtOutboundTarget jwtOutboundTarget = this.targetToJwtConfig.computeIfAbsent((OutboundTarget)target, this::toOutboundTarget);
                    if (null == jwtOutboundTarget.jwkKid) {
                        return subject.publicCredential(TokenCredential.class).map(tokenCredential -> this.propagate(jwtOutboundTarget, tokenCredential.token()));
                    }
                    return Optional.of(this.propagate(jwtOutboundTarget, (Subject)subject));
                });
            }).orElseGet(OutboundSecurityResponse::abstain);
        });
    }

    private OutboundSecurityResponse propagate(JwtOutboundTarget outboundTarget, String token) {
        HashMap headers = new HashMap();
        outboundTarget.outboundHandler.header(headers, token);
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private OutboundSecurityResponse propagate(JwtOutboundTarget ot, Subject subject) {
        HashMap headers = new HashMap();
        Jwk jwk = (Jwk)this.signKeys.forKeyId(ot.jwkKid).orElseThrow(() -> new JwtException("Signing JWK with kid: " + ot.jwkKid + " is not defined."));
        Principal principal = subject.principal();
        Jwt.Builder builder = Jwt.builder();
        principal.abacAttributeNames().forEach(name -> principal.abacAttribute(name).ifPresent(val -> builder.addPayloadClaim(name, val)));
        principal.abacAttribute("full_name").ifPresentOrElse(name -> builder.addPayloadClaim("name", name), () -> builder.removePayloadClaim("name"));
        builder.subject(principal.id()).preferredUsername(principal.getName()).issuer(this.issuer).algorithm(jwk.algorithm());
        ot.update(builder);
        if (!principal.abacAttribute("upn").isPresent()) {
            builder.userPrincipal(principal.getName());
        }
        Security.getRoles((Subject)subject).forEach(arg_0 -> ((Jwt.Builder)builder).addUserGroup(arg_0));
        Jwt jwt = builder.build();
        SignedJwt signed = SignedJwt.sign((Jwt)jwt, (Jwk)jwk);
        ot.outboundHandler.header(headers, signed.tokenContent());
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private OutboundSecurityResponse impersonate(JwtOutboundTarget ot, String username) {
        HashMap headers = new HashMap();
        Jwk jwk = (Jwk)this.signKeys.forKeyId(ot.jwkKid).orElseThrow(() -> new JwtException("Signing JWK with kid: " + ot.jwkKid + " is not defined."));
        Jwt.Builder builder = Jwt.builder();
        builder.addPayloadClaim("name", (Object)username);
        builder.subject(username).preferredUsername(username).issuer(this.issuer).algorithm(jwk.algorithm());
        ot.update(builder);
        Jwt jwt = builder.build();
        SignedJwt signed = SignedJwt.sign((Jwt)jwt, (Jwk)jwk);
        ot.outboundHandler.header(headers, signed.tokenContent());
        return OutboundSecurityResponse.withHeaders(headers);
    }

    private JwtOutboundTarget toOutboundTarget(OutboundTarget outboundTarget) {
        Optional customObject = outboundTarget.customObject(JwtOutboundTarget.class);
        if (customObject.isPresent()) {
            return (JwtOutboundTarget)customObject.get();
        }
        return JwtOutboundTarget.fromConfig(outboundTarget.getConfig().orElse(Config.empty()), this.defaultTokenHandler);
    }

    public static class Builder
    implements io.helidon.common.Builder<JwtAuthProvider> {
        private static final String CONFIG_PUBLIC_KEY = "mp.jwt.verify.publickey";
        private static final String CONFIG_PUBLIC_KEY_PATH = "mp.jwt.verify.publickey.location";
        private static final String JSON_START_MARK = "{";
        private static final Pattern PUBLIC_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PUBLIC\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n\\s]+)-+END\\s+.*PUBLIC\\s+KEY[^-]*-+", 2);
        private String expectedIssuer;
        private boolean optional = false;
        private boolean authenticate = true;
        private boolean propagate = true;
        private boolean allowImpersonation = false;
        private SubjectType subjectType = SubjectType.USER;
        private TokenHandler atnTokenHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
        private OutboundConfig outboundConfig;
        private JwkKeys verifyKeys;
        private JwkKeys signKeys;
        private Jwk defaultJwk;
        private String defaultKeyId;
        private String issuer;
        private String expectedAudience;
        private String publicKeyPath;
        private String publicKey;

        private Builder() {
        }

        public JwtAuthProvider build() {
            List keys;
            if (this.verifyKeys == null) {
                if (this.publicKeyPath != null && this.publicKey != null) {
                    throw new DeploymentException("Both mp.jwt.verify.publickey and mp.jwt.verify.publickey.location are set! Only one of them should be picked.");
                }
                this.verifyKeys = this.createJwkKeys();
            }
            if (null == this.defaultJwk && null != this.defaultKeyId) {
                this.defaultJwk = (Jwk)this.verifyKeys.forKeyId(this.defaultKeyId).orElseThrow(() -> new DeploymentException("Default key id defined as \"" + this.defaultKeyId + "\" yet the key id is not present in the JWK keys"));
            }
            if (null == this.defaultJwk && !(keys = this.verifyKeys.keys()).isEmpty()) {
                this.defaultJwk = (Jwk)keys.get(0);
            }
            return new JwtAuthProvider(this);
        }

        private JwkKeys createJwkKeys() {
            if (null == this.publicKeyPath && null == this.publicKey && null == this.defaultJwk) {
                LOGGER.severe("Either \"mp.jwt.verify.publickey\", or \"mp.jwt.verify.publickey.location\" must be configured; \"mp.jwt.verify.issuer\" should be configured.");
            }
            return Optional.ofNullable(this.publicKeyPath).map(this::loadJwkKeysFromLocation).or(() -> Optional.ofNullable(this.publicKey).map(pk -> this.loadJwkKeys("configuration", (String)pk))).or(() -> Optional.ofNullable(this.defaultJwk).map(jwk -> JwkKeys.builder().addKey(jwk).build())).orElseThrow(() -> new SecurityException("No public key or default JWK set for MP JWT-Auth Provider."));
        }

        private JwkKeys loadJwkKeysFromLocation(String uri) {
            return this.locatePath(uri).map(path -> {
                try {
                    return this.loadJwkKeys("file " + path, Files.readString(path, StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new SecurityException("Failed to load public key(s) from path: " + path.toAbsolutePath(), (Throwable)e);
                }
            }).orElseGet(() -> {
                JwkKeys jwkKeys;
                block9: {
                    InputStream is = this.locateStream(uri);
                    try {
                        if (null == is) {
                            throw new SecurityException("Could not find public key resource for MP JWT-Auth at: " + uri);
                        }
                        jwkKeys = this.getPublicKeyFromContent(uri, is);
                        if (is == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new SecurityException("Failed to load public key(s) from : " + uri, (Throwable)e);
                        }
                    }
                    is.close();
                }
                return jwkKeys;
            });
        }

        private Optional<Path> locatePath(String uri) {
            try {
                Path path = Paths.get(uri, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    return Optional.of(path);
                }
            }
            catch (InvalidPathException e) {
                LOGGER.log(Level.FINEST, "Could not locate path: " + uri, e);
            }
            return Optional.empty();
        }

        private InputStream locateStream(String uri) throws IOException {
            InputStream is;
            URL url = Thread.currentThread().getContextClassLoader().getResource(uri);
            if (url == null && uri.startsWith("/")) {
                url = Thread.currentThread().getContextClassLoader().getResource(uri.substring(1));
            }
            if (url == null) {
                is = JwtAuthProvider.class.getResourceAsStream(uri);
                if (null == is) {
                    try {
                        url = new URL(uri);
                    }
                    catch (MalformedURLException ignored2) {
                        LOGGER.finest(() -> "Configuration of public key(s) is not a valid URL: " + uri);
                        return null;
                    }
                    is = url.openStream();
                }
            } else {
                is = url.openStream();
            }
            return is;
        }

        private JwkKeys getPublicKeyFromContent(String location, InputStream bufferedInputStream) throws IOException {
            return this.loadJwkKeys(location, new String(bufferedInputStream.readAllBytes(), StandardCharsets.UTF_8));
        }

        private JwkKeys loadJwkKeys(String location, String stringContent) {
            if (stringContent.isEmpty()) {
                throw new SecurityException("Cannot load public key from " + location + ", as its content is empty");
            }
            Matcher m = PUBLIC_KEY_PATTERN.matcher(stringContent);
            if (m.find()) {
                return this.loadPlainPublicKey(stringContent);
            }
            if (stringContent.startsWith(JSON_START_MARK)) {
                return this.loadPublicKeyJWK(stringContent);
            }
            return this.loadPublicKeyJWKBase64(stringContent);
        }

        private JwkKeys loadPlainPublicKey(String stringContent) {
            return JwkKeys.builder().addKey((Jwk)JwkRSA.builder().publicKey((RSAPublicKey)KeyConfig.pemBuilder().publicKey(Resource.create((String)"public key from PKCS8", (String)stringContent)).build().publicKey().orElseThrow(() -> new DeploymentException("Failed to load public key from string content"))).build()).build();
        }

        private JwkKeys loadPublicKeyJWKBase64(String base64Encoded) {
            return this.loadPublicKeyJWK(new String(Base64.getUrlDecoder().decode(base64Encoded), StandardCharsets.UTF_8));
        }

        private JwkKeys loadPublicKeyJWK(String jwkJson) {
            if (jwkJson.contains("keys")) {
                return JwkKeys.builder().resource(Resource.create((String)"public key from PKCS8", (String)jwkJson)).build();
            }
            JsonObject jsonObject = JSON.createReader((Reader)new StringReader(jwkJson)).readObject();
            return JwkKeys.builder().addKey(Jwk.create((JsonObject)jsonObject)).build();
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder authenticate(boolean authenticate) {
            this.authenticate = authenticate;
            return this;
        }

        public Builder allowImpersonation(boolean allowImpersonation) {
            this.allowImpersonation = allowImpersonation;
            return this;
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder atnTokenHandler(TokenHandler tokenHandler) {
            this.atnTokenHandler = tokenHandler;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder outboundConfig(OutboundConfig config) {
            this.outboundConfig = config;
            return this;
        }

        public Builder signJwk(Resource signJwkResource) {
            this.signKeys = JwkKeys.builder().resource(signJwkResource).build();
            return this;
        }

        public Builder verifyJwk(Resource verifyJwkResource) {
            this.verifyKeys = JwkKeys.builder().resource(verifyJwkResource).build();
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.publicKeyPath = null;
            return this;
        }

        public Builder publicKeyPath(String publicKeyPath) {
            this.publicKeyPath = publicKeyPath;
            return this;
        }

        public Builder defaultJwk(Jwk defaultJwk) {
            this.defaultJwk = defaultJwk;
            return this;
        }

        public Builder defaultKeyId(String defaultKeyId) {
            this.defaultKeyId = defaultKeyId;
            return this;
        }

        public Builder config(Config config) {
            config.get("optional").asBoolean().ifPresent(this::optional);
            config.get("authenticate").asBoolean().ifPresent(this::authenticate);
            config.get("propagate").asBoolean().ifPresent(this::propagate);
            config.get("allow-impersonation").asBoolean().ifPresent(this::allowImpersonation);
            config.get("principal-type").asString().as(SubjectType::valueOf).ifPresent(this::subjectType);
            config.get("atn-token.handler").as(TokenHandler::create).ifPresent(this::atnTokenHandler);
            config.get("atn-token").ifExists(this::verifyKeys);
            config.get("atn-token.jwt-audience").asString().ifPresent(this::expectedAudience);
            config.get("atn-token.default-key-id").asString().ifPresent(this::defaultKeyId);
            config.get("atn-token.verify-key").asString().ifPresent(this::publicKeyPath);
            config.get("sign-token").ifExists(outbound -> this.outboundConfig(OutboundConfig.create((Config)outbound)));
            config.get("sign-token").ifExists(this::outbound);
            org.eclipse.microprofile.config.Config mpConfig = ConfigProviderResolver.instance().getConfig();
            mpConfig.getOptionalValue(CONFIG_PUBLIC_KEY, String.class).ifPresent(this::publicKey);
            mpConfig.getOptionalValue(CONFIG_PUBLIC_KEY_PATH, String.class).ifPresent(this::publicKeyPath);
            mpConfig.getOptionalValue(JwtAuthProvider.CONFIG_EXPECTED_ISSUER, String.class).ifPresent(this::expectedIssuer);
            if (null == this.publicKey && null == this.publicKeyPath) {
                String key = "helidon.mp.jwt.verify.publickey.location";
                mpConfig.getOptionalValue(key, String.class).ifPresent(it -> {
                    this.publicKeyPath((String)it);
                    LOGGER.warning("You have configured public key for JWT-Auth provider using a property reserved for TCK tests (" + key + "). Please use mp.jwt.verify.publickey.location instead.");
                });
            }
            return this;
        }

        public Builder expectedIssuer(String issuer) {
            this.expectedIssuer = issuer;
            return this;
        }

        public Builder expectedAudience(String audience) {
            this.expectedAudience = audience;
            return this;
        }

        private void verifyKeys(Config config) {
            config.get("jwk.resource").as(Resource::create).ifPresent(this::verifyJwk);
            Resource.create((Config)config, (String)"jwk").ifPresent(this::verifyJwk);
        }

        private void outbound(Config config) {
            config.get("jwt-issuer").asString().ifPresent(this::issuer);
            config.get("jwk.resource").as(Resource::create).ifPresent(this::signJwk);
            Resource.create((Config)config, (String)"jwk").ifPresent(this::signJwk);
        }
    }

    public static class JwtOutboundTarget {
        private final TokenHandler outboundHandler;
        private final String jwtKid;
        private final String jwkKid;
        private final String jwtAudience;
        private final int notBeforeSeconds;
        private final long validitySeconds;

        public JwtOutboundTarget(TokenHandler outboundHandler, String jwtKid, String jwkKid, String audience, int notBeforeSeconds, long validitySeconds) {
            this.outboundHandler = outboundHandler;
            this.jwtKid = jwtKid;
            this.jwkKid = jwkKid;
            this.jwtAudience = audience;
            this.notBeforeSeconds = notBeforeSeconds;
            this.validitySeconds = validitySeconds;
        }

        public static JwtOutboundTarget fromConfig(Config config, TokenHandler defaultHandler) {
            TokenHandler tokenHandler = config.get("outbound-token").asNode().map(TokenHandler::create).orElse(defaultHandler);
            return new JwtOutboundTarget(tokenHandler, (String)config.get("jwt-kid").asString().orElse(null), (String)config.get("jwk-kid").asString().orElse(null), (String)config.get("jwt-audience").asString().orElse(null), (Integer)config.get("jwt-not-before-seconds").asInt().orElse((Object)5), (Long)config.get("jwt-validity-seconds").asLong().orElse((Object)86400L));
        }

        private void update(Jwt.Builder builder) {
            Instant now = Instant.now();
            Instant exp = now.plus(this.validitySeconds, ChronoUnit.SECONDS);
            Instant notBefore = now.minus(this.notBeforeSeconds, ChronoUnit.SECONDS);
            builder.issueTime(now).expirationTime(exp).notBefore(notBefore).keyId(this.jwtKid).audience(this.jwtAudience);
        }
    }
}

