/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.HelidonMetric;
import io.helidon.microprofile.metrics.BasicMetricWorkItem;
import io.helidon.microprofile.metrics.MetricsCdiExtension;
import io.helidon.microprofile.metrics.TypeFilteredIterable;
import io.helidon.servicecommon.restcdi.HelidonInterceptor;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

abstract class MetricsInterceptorBase<M extends Metric>
extends HelidonInterceptor.Base<BasicMetricWorkItem> {
    static final Logger LOGGER = Logger.getLogger(MetricsInterceptorBase.class.getName());
    private final Class<? extends Annotation> annotationType;
    private final Class<M> metricType;
    @Inject
    private MetricsCdiExtension extension;
    @Inject
    private MetricRegistry registry;

    MetricsInterceptorBase(Class<? extends Annotation> annotationType, Class<M> metricType) {
        this.annotationType = annotationType;
        this.metricType = metricType;
    }

    public Iterable<BasicMetricWorkItem> workItems(Executable executable) {
        return TypeFilteredIterable.create(this.extension.workItems(executable, this.annotationType), BasicMetricWorkItem.class);
    }

    public void preInvocation(InvocationContext context, BasicMetricWorkItem workItem) {
        this.verifyMetric(context, workItem.metricID(), workItem.metric(), ActionType.PREINVOKE);
        this.preInvoke((Metric)this.metricType.cast(workItem.metric()));
    }

    void verifyMetric(InvocationContext context, MetricID metricID, Metric metric, ActionType actionType) {
        MetricsInterceptorBase.verifyMetric(metricID, metric);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, String.format("%s (%s) is accepting %s %s for processing on %s triggered by @%s", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), actionType, metric.getClass().getSimpleName(), metricID, context.getMethod() != null ? context.getMethod() : context.getConstructor(), this.annotationType.getSimpleName()}));
        }
    }

    static void verifyMetric(MetricID metricID, Metric metric) {
        if (HelidonMetric.isMarkedAsDeleted((Metric)metric)) {
            throw new IllegalStateException("Attempt to use previously-removed metric" + metricID);
        }
    }

    abstract void preInvoke(M var1);

    static enum ActionType {
        PREINVOKE("preinvoke"),
        COMPLETE("complete");

        private final String label;

        private ActionType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    static abstract class WithPostCompletion<T extends Metric>
    extends MetricsInterceptorBase<T>
    implements HelidonInterceptor.WithPostCompletion<BasicMetricWorkItem> {
        private final Class<T> metricType;

        WithPostCompletion(Class<? extends Annotation> annotationType, Class<T> metricType) {
            super(annotationType, metricType);
            this.metricType = metricType;
        }

        public void postCompletion(InvocationContext context, Throwable throwable, BasicMetricWorkItem workItem) {
            this.verifyMetric(context, workItem.metricID(), workItem.metric(), ActionType.COMPLETE);
            this.postComplete((Metric)this.metricType.cast(workItem.metric()));
        }

        abstract void postComplete(T var1);
    }
}

