/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.JwtHeaders;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.Validator;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class Jwt {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final JwtHeaders headers;
    private final Map<String, JsonValue> payloadClaims;
    private final Optional<String> issuer;
    private final Optional<Instant> expirationTime;
    private final Optional<Instant> issueTime;
    private final Optional<Instant> notBefore;
    private final Optional<String> subject;
    private final Optional<String> userPrincipal;
    private final Optional<List<String>> userGroups;
    private final Optional<List<String>> audience;
    private final Optional<String> jwtId;
    private final Optional<String> email;
    private final Optional<Boolean> emailVerified;
    private final Optional<String> fullName;
    private final Optional<String> givenName;
    private final Optional<String> middleName;
    private final Optional<String> familyName;
    private final Optional<Locale> locale;
    private final Optional<String> nickname;
    private final Optional<String> preferredUsername;
    private final Optional<URI> profile;
    private final Optional<URI> picture;
    private final Optional<URI> website;
    private final Optional<String> gender;
    private final Optional<LocalDate> birthday;
    private final Optional<ZoneId> timeZone;
    private final Optional<String> phoneNumber;
    private final Optional<Boolean> phoneNumberVerified;
    private final Optional<Instant> updatedAt;
    private final Optional<JwtUtil.Address> address;
    private final Optional<List<String>> scopes;
    private final Optional<byte[]> atHash;
    private final Optional<byte[]> cHash;
    private final Optional<String> nonce;

    Jwt(JwtHeaders headers, JsonObject payloadJson) {
        this.headers = headers;
        this.payloadClaims = this.getClaims(payloadJson);
        this.issuer = JwtUtil.getString(payloadJson, "iss");
        this.expirationTime = JwtUtil.toInstant(payloadJson, "exp");
        this.issueTime = JwtUtil.toInstant(payloadJson, "iat");
        this.notBefore = JwtUtil.toInstant(payloadJson, "nbf");
        this.subject = JwtUtil.getString(payloadJson, "sub");
        JsonValue groups = (JsonValue)payloadJson.get((Object)"groups");
        this.userGroups = groups instanceof JsonArray ? JwtUtil.getStrings(payloadJson, "groups") : JwtUtil.getString(payloadJson, "groups").map(List::of);
        JsonValue aud = (JsonValue)payloadJson.get((Object)"aud");
        this.audience = aud instanceof JsonArray ? JwtUtil.getStrings(payloadJson, "aud") : JwtUtil.getString(payloadJson, "aud").map(List::of);
        this.jwtId = JwtUtil.getString(payloadJson, "jti");
        this.email = JwtUtil.getString(payloadJson, "email");
        this.emailVerified = JwtUtil.toBoolean(payloadJson, "email_verified");
        this.fullName = JwtUtil.getString(payloadJson, "name");
        this.givenName = JwtUtil.getString(payloadJson, "given_name");
        this.middleName = JwtUtil.getString(payloadJson, "middle_name");
        this.familyName = JwtUtil.getString(payloadJson, "family_name");
        this.locale = JwtUtil.toLocale(payloadJson, "locale");
        this.nickname = JwtUtil.getString(payloadJson, "nickname");
        this.preferredUsername = JwtUtil.getString(payloadJson, "preferred_username");
        this.profile = JwtUtil.toUri(payloadJson, "profile");
        this.picture = JwtUtil.toUri(payloadJson, "picture");
        this.website = JwtUtil.toUri(payloadJson, "website");
        this.gender = JwtUtil.getString(payloadJson, "gender");
        this.birthday = JwtUtil.toDate(payloadJson, "birthday");
        this.timeZone = JwtUtil.toTimeZone(payloadJson, "zoneinfo");
        this.phoneNumber = JwtUtil.getString(payloadJson, "phone_number");
        this.phoneNumberVerified = JwtUtil.toBoolean(payloadJson, "phone_number_verified");
        this.updatedAt = JwtUtil.toInstant(payloadJson, "updated_at");
        this.address = JwtUtil.toAddress(payloadJson, "address");
        this.atHash = JwtUtil.getByteArray(payloadJson, "at_hash", "at_hash value");
        this.cHash = JwtUtil.getByteArray(payloadJson, "c_hash", "c_hash value");
        this.nonce = JwtUtil.getString(payloadJson, "nonce");
        this.scopes = JwtUtil.toScopes(payloadJson);
        this.userPrincipal = JwtUtil.getString(payloadJson, "upn").or(() -> this.preferredUsername).or(() -> this.subject);
    }

    private Jwt(Builder builder) {
        this.payloadClaims = new HashMap<String, JsonValue>();
        this.payloadClaims.putAll(JwtUtil.transformToJson(builder.payloadClaims));
        this.headers = builder.headerBuilder.build();
        this.issuer = builder.issuer;
        this.expirationTime = builder.expirationTime;
        this.issueTime = builder.issueTime;
        this.notBefore = builder.notBefore;
        this.subject = builder.subject.or(() -> Jwt.toOptionalString(builder.payloadClaims, "sub"));
        this.audience = Optional.ofNullable(builder.audience);
        this.jwtId = builder.jwtId;
        this.email = builder.email.or(() -> Jwt.toOptionalString(builder.payloadClaims, "email"));
        this.emailVerified = builder.emailVerified.or(() -> Jwt.getClaim(builder.payloadClaims, "email_verified"));
        this.fullName = builder.fullName.or(() -> Jwt.toOptionalString(builder.payloadClaims, "name"));
        this.givenName = builder.givenName.or(() -> Jwt.toOptionalString(builder.payloadClaims, "given_name"));
        this.middleName = builder.middleName.or(() -> Jwt.toOptionalString(builder.payloadClaims, "middle_name"));
        this.familyName = builder.familyName.or(() -> Jwt.toOptionalString(builder.payloadClaims, "family_name"));
        this.locale = builder.locale.or(() -> Jwt.getClaim(builder.payloadClaims, "locale"));
        this.nickname = builder.nickname.or(() -> Jwt.toOptionalString(builder.payloadClaims, "nickname"));
        this.preferredUsername = builder.preferredUsername.or(() -> Jwt.toOptionalString(builder.payloadClaims, "preferred_username"));
        this.profile = builder.profile.or(() -> Jwt.getClaim(builder.payloadClaims, "profile"));
        this.picture = builder.picture.or(() -> Jwt.getClaim(builder.payloadClaims, "picture"));
        this.website = builder.website.or(() -> Jwt.getClaim(builder.payloadClaims, "website"));
        this.gender = builder.gender.or(() -> Jwt.toOptionalString(builder.payloadClaims, "gender"));
        this.birthday = builder.birthday.or(() -> Jwt.getClaim(builder.payloadClaims, "birthday"));
        this.timeZone = builder.timeZone.or(() -> Jwt.getClaim(builder.payloadClaims, "zoneinfo"));
        this.phoneNumber = builder.phoneNumber.or(() -> Jwt.toOptionalString(builder.payloadClaims, "phone_number"));
        this.phoneNumberVerified = builder.phoneNumberVerified.or(() -> Jwt.getClaim(builder.payloadClaims, "phone_number_verified"));
        this.updatedAt = builder.updatedAt;
        this.address = builder.address;
        this.atHash = builder.atHash;
        this.cHash = builder.cHash;
        this.nonce = builder.nonce;
        this.scopes = builder.scopes;
        this.userPrincipal = builder.userPrincipal.or(() -> Jwt.toOptionalString(builder.payloadClaims, "upn")).or(() -> this.preferredUsername).or(() -> this.subject);
        this.userGroups = builder.userGroups;
    }

    private static <T> Optional<T> getClaim(Map<String, Object> claims, String claim) {
        return Optional.ofNullable(claims.get(claim));
    }

    private static Optional<String> toOptionalString(Map<String, Object> claims, String claim) {
        Object value = claims.get(claim);
        if (null == value) {
            return Optional.empty();
        }
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.of(String.valueOf(value));
    }

    public static List<Validator<Jwt>> defaultTimeValidators() {
        LinkedList<Validator<Jwt>> validators = new LinkedList<Validator<Jwt>>();
        validators.add(new ExpirationValidator(false));
        validators.add(new IssueTimeValidator());
        validators.add(new NotBeforeValidator());
        return validators;
    }

    public static List<Validator<Jwt>> defaultTimeValidators(Instant now, int timeSkewAmount, ChronoUnit timeSkewUnit, boolean mandatory) {
        LinkedList<Validator<Jwt>> validators = new LinkedList<Validator<Jwt>>();
        validators.add(new ExpirationValidator(now, timeSkewAmount, timeSkewUnit, mandatory));
        validators.add(new IssueTimeValidator(now, timeSkewAmount, timeSkewUnit, mandatory));
        validators.add(new NotBeforeValidator(now, timeSkewAmount, timeSkewUnit, mandatory));
        return validators;
    }

    public static void addIssuerValidator(Collection<Validator<Jwt>> validators, String issuer, boolean mandatory) {
        validators.add(FieldValidator.create(Jwt::issuer, "Issuer", issuer, mandatory));
    }

    public static void addAudienceValidator(Collection<Validator<Jwt>> validators, String audience, boolean mandatory) {
        Jwt.addAudienceValidator(validators, Set.of(audience), mandatory);
    }

    public static void addAudienceValidator(Collection<Validator<Jwt>> validators, Set<String> audience, boolean mandatory) {
        validators.add((jwt, collector) -> {
            Optional<List<String>> jwtAudiences = jwt.audience();
            if (jwtAudiences.isPresent()) {
                if (audience.stream().anyMatch(jwtAudiences.get()::contains)) {
                    return;
                }
                collector.fatal(jwt, "Audience must contain " + audience + ", yet it is: " + jwtAudiences);
            } else if (mandatory) {
                collector.fatal(jwt, "Audience is expected to be: " + audience + ", yet no audience in JWT");
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    private Map<String, JsonValue> getClaims(JsonObject headerJson) {
        return Collections.unmodifiableMap(headerJson);
    }

    public Optional<List<String>> scopes() {
        return this.scopes.map(Collections::unmodifiableList);
    }

    public Optional<JsonValue> headerClaim(String claim) {
        return this.headers.headerClaim(claim);
    }

    public Optional<JsonValue> payloadClaim(String claim) {
        JsonValue rawValue = this.payloadClaims.get(claim);
        switch (claim) {
            case "aud": {
                return Optional.ofNullable(this.ensureJsonArray(rawValue));
            }
        }
        return Optional.ofNullable(rawValue);
    }

    private JsonValue ensureJsonArray(JsonValue rawValue) {
        if (rawValue instanceof JsonArray) {
            return rawValue;
        }
        return JSON.createArrayBuilder().add(rawValue).build();
    }

    public JwtHeaders headers() {
        return this.headers;
    }

    public Map<String, JsonValue> payloadClaims() {
        return Collections.unmodifiableMap(this.payloadClaims);
    }

    public Optional<String> algorithm() {
        return this.headers.algorithm();
    }

    public Optional<String> keyId() {
        return this.headers.keyId();
    }

    public Optional<String> type() {
        return this.headers.type();
    }

    public Optional<String> contentType() {
        return this.headers.contentType();
    }

    public Optional<String> issuer() {
        return this.issuer;
    }

    public Optional<Instant> expirationTime() {
        return this.expirationTime;
    }

    public Optional<Instant> issueTime() {
        return this.issueTime;
    }

    public Optional<Instant> notBefore() {
        return this.notBefore;
    }

    public Optional<String> subject() {
        return this.subject;
    }

    public Optional<String> userPrincipal() {
        return this.userPrincipal;
    }

    public Optional<List<String>> userGroups() {
        return this.userGroups.map(Collections::unmodifiableList);
    }

    public Optional<List<String>> audience() {
        return this.audience;
    }

    public Optional<String> jwtId() {
        return this.jwtId;
    }

    public Optional<String> email() {
        return this.email;
    }

    public Optional<Boolean> emailVerified() {
        return this.emailVerified;
    }

    public Optional<String> fullName() {
        return this.fullName;
    }

    public Optional<String> givenName() {
        return this.givenName;
    }

    public Optional<String> middleName() {
        return this.middleName;
    }

    public Optional<String> familyName() {
        return this.familyName;
    }

    public Optional<Locale> locale() {
        return this.locale;
    }

    public Optional<String> nickname() {
        return this.nickname;
    }

    public Optional<String> preferredUsername() {
        return this.preferredUsername;
    }

    public Optional<URI> profile() {
        return this.profile;
    }

    public Optional<URI> picture() {
        return this.picture;
    }

    public Optional<URI> website() {
        return this.website;
    }

    public Optional<String> gender() {
        return this.gender;
    }

    public Optional<LocalDate> birthday() {
        return this.birthday;
    }

    public Optional<ZoneId> timeZone() {
        return this.timeZone;
    }

    public Optional<String> phoneNumber() {
        return this.phoneNumber;
    }

    public Optional<Boolean> phoneNumberVerified() {
        return this.phoneNumberVerified;
    }

    public Optional<Instant> updatedAt() {
        return this.updatedAt;
    }

    public Optional<JwtUtil.Address> address() {
        return this.address;
    }

    public Optional<byte[]> atHash() {
        return this.atHash;
    }

    public Optional<byte[]> cHash() {
        return this.cHash;
    }

    public Optional<String> nonce() {
        return this.nonce;
    }

    public JsonObject headerJson() {
        return this.headers.headerJson();
    }

    public JsonObject payloadJson() {
        JsonObjectBuilder objectBuilder = JSON.createObjectBuilder();
        this.payloadClaims.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)objectBuilder).add(arg_0, arg_1));
        this.issuer.ifPresent(it -> objectBuilder.add("iss", it));
        this.expirationTime.ifPresent(it -> objectBuilder.add("exp", it.getEpochSecond()));
        this.issueTime.ifPresent(it -> objectBuilder.add("iat", it.getEpochSecond()));
        this.notBefore.ifPresent(it -> objectBuilder.add("nbf", it.getEpochSecond()));
        this.subject.ifPresent(it -> objectBuilder.add("sub", it));
        this.userPrincipal.ifPresent(it -> objectBuilder.add("upn", it));
        this.userGroups.ifPresent(it -> {
            JsonArrayBuilder jab = JSON.createArrayBuilder();
            it.forEach(arg_0 -> ((JsonArrayBuilder)jab).add(arg_0));
            objectBuilder.add("groups", jab);
        });
        this.audience.ifPresent(it -> {
            JsonArrayBuilder jab = JSON.createArrayBuilder();
            it.forEach(arg_0 -> ((JsonArrayBuilder)jab).add(arg_0));
            objectBuilder.add("aud", jab);
        });
        this.jwtId.ifPresent(it -> objectBuilder.add("jti", it));
        this.email.ifPresent(it -> objectBuilder.add("email", it));
        this.emailVerified.ifPresent(it -> objectBuilder.add("email_verified", it.booleanValue()));
        this.fullName.ifPresent(it -> objectBuilder.add("name", it));
        this.givenName.ifPresent(it -> objectBuilder.add("given_name", it));
        this.middleName.ifPresent(it -> objectBuilder.add("middle_name", it));
        this.familyName.ifPresent(it -> objectBuilder.add("family_name", it));
        this.locale.ifPresent(it -> objectBuilder.add("locale", it.toLanguageTag()));
        this.nickname.ifPresent(it -> objectBuilder.add("nickname", it));
        this.preferredUsername.ifPresent(it -> objectBuilder.add("preferred_username", it));
        this.profile.ifPresent(it -> objectBuilder.add("profile", it.toASCIIString()));
        this.picture.ifPresent(it -> objectBuilder.add("picture", it.toASCIIString()));
        this.website.ifPresent(it -> objectBuilder.add("website", it.toASCIIString()));
        this.gender.ifPresent(it -> objectBuilder.add("gender", it));
        this.birthday.ifPresent(it -> objectBuilder.add("birthday", JwtUtil.toDate(it)));
        this.timeZone.ifPresent(it -> objectBuilder.add("zoneinfo", it.getId()));
        this.phoneNumber.ifPresent(it -> objectBuilder.add("phone_number", it));
        this.phoneNumberVerified.ifPresent(it -> objectBuilder.add("phone_number_verified", it.booleanValue()));
        this.updatedAt.ifPresent(it -> objectBuilder.add("updated_at", it.getEpochSecond()));
        this.address.ifPresent(it -> objectBuilder.add("address", (JsonValue)it.getJson()));
        this.atHash.ifPresent(it -> objectBuilder.add("at_hash", JwtUtil.base64Url(it)));
        this.cHash.ifPresent(it -> objectBuilder.add("c_hash", JwtUtil.base64Url(it)));
        this.nonce.ifPresent(it -> objectBuilder.add("nonce", it));
        this.scopes.ifPresent(it -> {
            String scopesString = String.join((CharSequence)" ", it);
            objectBuilder.add("scope", scopesString);
        });
        return objectBuilder.build();
    }

    public Errors validate(List<Validator<Jwt>> validators) {
        Errors.Collector collector = Errors.collector();
        validators.forEach(it -> it.validate(this, collector));
        return collector.collect();
    }

    public Errors validate(String issuer, String audience) {
        return this.validate(issuer, Set.of(audience));
    }

    public Errors validate(String issuer, Set<String> audience) {
        List<Validator<Jwt>> validators = Jwt.defaultTimeValidators();
        if (null != issuer) {
            Jwt.addIssuerValidator(validators, issuer, true);
        }
        if (null != audience) {
            audience.stream().filter(Objects::nonNull).findAny().ifPresent(it -> Jwt.addAudienceValidator((Collection<Validator<Jwt>>)validators, audience, true));
        }
        Jwt.addUserPrincipalValidator(validators);
        return this.validate(validators);
    }

    public static void addUserPrincipalValidator(Collection<Validator<Jwt>> validators) {
        validators.add(new UserPrincipalValidator());
    }

    private static final class UserPrincipalValidator
    extends OptionalValidator
    implements Validator<Jwt> {
        private UserPrincipalValidator() {
            super(true);
        }

        @Override
        public void validate(Jwt object, Errors.Collector collector) {
            super.validate("User Principal", object.userPrincipal(), collector);
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Jwt> {
        private final JwtHeaders.Builder headerBuilder = JwtHeaders.builder();
        private final Map<String, Object> payloadClaims = new HashMap<String, Object>();
        private Optional<String> issuer = Optional.empty();
        private Optional<Instant> expirationTime = Optional.empty();
        private Optional<Instant> issueTime = Optional.empty();
        private Optional<Instant> notBefore = Optional.empty();
        private Optional<String> subject = Optional.empty();
        private Optional<String> userPrincipal = Optional.empty();
        private Optional<List<String>> userGroups = Optional.empty();
        private List<String> audience;
        private Optional<String> jwtId = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<Boolean> emailVerified = Optional.empty();
        private Optional<String> fullName = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        private Optional<String> middleName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<Locale> locale = Optional.empty();
        private Optional<String> nickname = Optional.empty();
        private Optional<String> preferredUsername = Optional.empty();
        private Optional<URI> profile = Optional.empty();
        private Optional<URI> picture = Optional.empty();
        private Optional<URI> website = Optional.empty();
        private Optional<String> gender = Optional.empty();
        private Optional<LocalDate> birthday = Optional.empty();
        private Optional<ZoneId> timeZone = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<Boolean> phoneNumberVerified = Optional.empty();
        private Optional<Instant> updatedAt = Optional.empty();
        private Optional<JwtUtil.Address> address = Optional.empty();
        private Optional<byte[]> atHash = Optional.empty();
        private Optional<byte[]> cHash = Optional.empty();
        private Optional<String> nonce = Optional.empty();
        private Optional<List<String>> scopes = Optional.empty();

        private Builder() {
        }

        public Builder keyId(String keyId) {
            this.headerBuilder.keyId(keyId);
            return this;
        }

        public Builder type(String type) {
            this.headerBuilder.type(type);
            return this;
        }

        public Builder scopes(List<String> scopes) {
            LinkedList<String> list = new LinkedList<String>(scopes);
            this.scopes = Optional.of(list);
            return this;
        }

        public Builder addScope(String scope) {
            this.scopes = this.scopes.or(() -> Optional.of(new LinkedList()));
            this.scopes.ifPresent(it -> it.add(scope));
            return this;
        }

        public Builder addUserGroup(String group) {
            this.userGroups = this.userGroups.or(() -> Optional.of(new LinkedList()));
            this.userGroups.ifPresent(it -> it.add(group));
            return this;
        }

        public Builder contentType(String contentType) {
            this.headerBuilder.contentType(contentType);
            return this;
        }

        public Builder addHeaderClaim(String claim, Object value) {
            this.headerBuilder.addHeaderClaim(claim, value);
            return this;
        }

        private void addClaim(Map<String, Object> claims, String claim, Object value) {
            claims.put(claim, value);
        }

        public Builder addPayloadClaim(String claim, Object value) {
            this.addClaim(this.payloadClaims, claim, value);
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.headerBuilder.algorithm(algorithm);
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = Optional.ofNullable(issuer);
            return this;
        }

        public Builder expirationTime(Instant expirationTime) {
            this.expirationTime = Optional.ofNullable(expirationTime);
            return this;
        }

        public Builder issueTime(Instant issueTime) {
            this.issueTime = Optional.ofNullable(issueTime);
            return this;
        }

        public Builder notBefore(Instant notBefore) {
            this.notBefore = Optional.ofNullable(notBefore);
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Optional.ofNullable(subject);
            return this;
        }

        public Builder userPrincipal(String principal) {
            this.userPrincipal = Optional.ofNullable(principal);
            return this;
        }

        public Builder addAudience(String audience) {
            if (this.audience == null) {
                this.audience = new LinkedList<String>();
            }
            this.audience.add(audience);
            return this;
        }

        @Deprecated(forRemoval=true, since="2.4.0")
        public Builder audience(String audience) {
            return this.addAudience(audience);
        }

        public Builder audience(List<String> audience) {
            this.audience = new LinkedList<String>(audience);
            return this;
        }

        public Builder jwtId(String jwtId) {
            this.jwtId = Optional.ofNullable(jwtId);
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder emailVerified(Boolean emailVerified) {
            this.emailVerified = Optional.ofNullable(emailVerified);
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = Optional.ofNullable(fullName);
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        public Builder middleName(String middleName) {
            this.middleName = Optional.ofNullable(middleName);
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = Optional.ofNullable(nickname);
            return this;
        }

        public Builder preferredUsername(String preferredUsername) {
            this.preferredUsername = Optional.ofNullable(preferredUsername);
            return this;
        }

        public Builder profile(URI profile) {
            this.profile = Optional.ofNullable(profile);
            return this;
        }

        public Builder picture(URI picture) {
            this.picture = Optional.ofNullable(picture);
            return this;
        }

        public Builder website(URI website) {
            this.website = Optional.ofNullable(website);
            return this;
        }

        public Builder gender(String gender) {
            this.gender = Optional.ofNullable(gender);
            return this;
        }

        public Builder birthday(LocalDate birthday) {
            this.birthday = Optional.ofNullable(birthday);
            return this;
        }

        public Builder timeZone(ZoneId timeZone) {
            this.timeZone = Optional.ofNullable(timeZone);
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumberVerified(Boolean phoneNumberVerified) {
            this.phoneNumberVerified = Optional.ofNullable(phoneNumberVerified);
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public Builder address(JwtUtil.Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder atHash(byte[] atHash) {
            this.atHash = Optional.ofNullable(atHash);
            return this;
        }

        public Builder cHash(byte[] cHash) {
            this.cHash = Optional.ofNullable(cHash);
            return this;
        }

        public Builder nonce(String nonce) {
            this.nonce = Optional.ofNullable(nonce);
            return this;
        }

        public Jwt build() {
            return new Jwt(this);
        }

        public Builder removePayloadClaim(String name) {
            this.payloadClaims.remove(name);
            return this;
        }
    }

    public static final class NotBeforeValidator
    extends InstantValidator
    implements Validator<Jwt> {
        private NotBeforeValidator() {
        }

        private NotBeforeValidator(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        public static NotBeforeValidator create() {
            return new NotBeforeValidator();
        }

        public static NotBeforeValidator create(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            return new NotBeforeValidator(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            Optional<Instant> notBefore = token.notBefore();
            notBefore.ifPresent(it -> {
                if (this.latest().isBefore((Instant)it)) {
                    collector.fatal((Object)token, "Token not yet valid, not before: " + it);
                }
            });
            super.validate("notBefore", notBefore, collector);
        }
    }

    public static final class ExpirationValidator
    extends InstantValidator
    implements Validator<Jwt> {
        private ExpirationValidator(boolean mandatory) {
            super(mandatory);
        }

        private ExpirationValidator(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        public static ExpirationValidator create() {
            return new ExpirationValidator(false);
        }

        public static ExpirationValidator create(boolean mandatory) {
            return new ExpirationValidator(mandatory);
        }

        public static ExpirationValidator create(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            return new ExpirationValidator(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            Optional<Instant> expirationTime = token.expirationTime();
            expirationTime.ifPresent(it -> {
                if (this.earliest().isAfter((Instant)it)) {
                    collector.fatal((Object)token, "Token no longer valid, expiration: " + it);
                }
            });
            super.validate("expirationTime", expirationTime, collector);
        }
    }

    public static final class IssueTimeValidator
    extends InstantValidator
    implements Validator<Jwt> {
        private IssueTimeValidator() {
        }

        private IssueTimeValidator(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        public static IssueTimeValidator create() {
            return new IssueTimeValidator();
        }

        public static IssueTimeValidator create(Instant now, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            return new IssueTimeValidator(now, allowedTimeSkew, allowedTimeSkewUnit, mandatory);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            Optional<Instant> issueTime = token.issueTime();
            issueTime.ifPresent(it -> {
                if (this.latest().isBefore((Instant)it)) {
                    collector.fatal((Object)token, "Token was not issued in the past: " + it);
                }
            });
            super.validate("issueTime", issueTime, collector);
        }
    }

    public static final class FieldValidator
    extends OptionalValidator
    implements Validator<Jwt> {
        private final Function<Jwt, Optional<String>> fieldAccessor;
        private final String expectedValue;
        private final String fieldName;

        private FieldValidator(Function<Jwt, Optional<String>> fieldAccessor, String fieldName, String expectedValue, boolean mandatory) {
            super(mandatory);
            this.fieldAccessor = fieldAccessor;
            this.fieldName = fieldName;
            this.expectedValue = expectedValue;
        }

        public static FieldValidator create(Function<Jwt, Optional<String>> fieldAccessor, String name, String expectedValue) {
            return FieldValidator.create(fieldAccessor, name, expectedValue, false);
        }

        public static FieldValidator create(Function<Jwt, Optional<String>> fieldAccessor, String name, String expectedValue, boolean mandatory) {
            return new FieldValidator(fieldAccessor, name, expectedValue, mandatory);
        }

        public static FieldValidator createForHeader(String fieldKey, String name, String expectedValue) {
            return FieldValidator.createForHeader(fieldKey, name, expectedValue, false);
        }

        public static FieldValidator createForHeader(String fieldKey, String name, String expectedValue, boolean mandatory) {
            return FieldValidator.create(jwt -> jwt.headerClaim(fieldKey).map(it -> ((JsonString)it).getString()), name, expectedValue, mandatory);
        }

        public static FieldValidator createForPayload(String fieldKey, String name, String expectedValue) {
            return FieldValidator.createForPayload(fieldKey, name, expectedValue, false);
        }

        public static FieldValidator createForPayload(String fieldKey, String name, String expectedValue, boolean mandatory) {
            return FieldValidator.create(jwt -> jwt.payloadClaim(fieldKey).map(it -> ((JsonString)it).getString()), name, expectedValue, false);
        }

        @Override
        public void validate(Jwt token, Errors.Collector collector) {
            super.validate(this.fieldName, this.fieldAccessor.apply(token), collector).ifPresent(it -> {
                if (!this.expectedValue.equals(it)) {
                    collector.fatal((Object)token, "Expected value of field \"" + this.fieldName + "\" was \"" + this.expectedValue + "\", but actual value is: \"" + it);
                }
            });
        }
    }

    private static abstract class InstantValidator
    extends OptionalValidator {
        private final Instant instant;
        private final long allowedTimeSkewAmount;
        private final TemporalUnit allowedTimeSkewUnit;

        private InstantValidator() {
            this.instant = Instant.now();
            this.allowedTimeSkewAmount = 5L;
            this.allowedTimeSkewUnit = ChronoUnit.SECONDS;
        }

        private InstantValidator(boolean mandatory) {
            super(mandatory);
            this.instant = Instant.now();
            this.allowedTimeSkewAmount = 5L;
            this.allowedTimeSkewUnit = ChronoUnit.SECONDS;
        }

        private InstantValidator(Instant instant, int allowedTimeSkew, TemporalUnit allowedTimeSkewUnit, boolean mandatory) {
            super(mandatory);
            this.instant = instant;
            this.allowedTimeSkewAmount = allowedTimeSkew;
            this.allowedTimeSkewUnit = allowedTimeSkewUnit;
        }

        Instant latest() {
            return this.instant.plus(this.allowedTimeSkewAmount, this.allowedTimeSkewUnit);
        }

        Instant earliest() {
            return this.instant.minus(this.allowedTimeSkewAmount, this.allowedTimeSkewUnit);
        }
    }

    private static abstract class OptionalValidator {
        private final boolean mandatory;

        OptionalValidator() {
            this.mandatory = false;
        }

        OptionalValidator(boolean mandatory) {
            this.mandatory = mandatory;
        }

        <T> Optional<T> validate(String name, Optional<T> optional, Errors.Collector collector) {
            if (this.mandatory && optional.isEmpty()) {
                collector.fatal("Field " + name + " is mandatory, yet not defined in JWT");
            }
            return optional;
        }
    }
}

