/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;

class JwtClaims {
    private static final Base64.Decoder URL_DECODER = Base64.getUrlDecoder();
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());

    protected JwtClaims() {
    }

    protected static String decode(String base64, Errors.Collector collector, String description) {
        try {
            return new String(URL_DECODER.decode(base64), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            collector.fatal((Object)base64, description + " is not a base64 encoded string.");
            return null;
        }
    }

    protected static JsonObject parseJson(String jsonString, Errors.Collector collector, String base64, String description) {
        try {
            return JSON.createReader((Reader)new StringReader(jsonString)).readObject();
        }
        catch (Exception e) {
            collector.fatal((Object)base64, description + " is not a valid JSON object (value is base64 encoded)");
            return null;
        }
    }
}

