/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.security.integration.jersey.QueryParamHandler;
import io.helidon.security.integration.jersey.SecurityFeature;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class FeatureConfig {
    static final boolean DEFAULT_DEBUG = false;
    static final boolean DEFAULT_ATZ_ANNOTATED_ONLY = false;
    static final boolean DEFAULT_ATN_ANNOTATED_ONLY = true;
    static final boolean DEFAULT_PREMATCHING_ATN = false;
    static final boolean DEFAULT_PREMATCHING_ATZ = false;
    static final boolean DEFAULT_USE_ABORT_WITH = true;
    private final boolean debug;
    private final boolean authorizeAnnotatedOnly;
    private final boolean usePrematchingAtn;
    private final boolean usePrematchingAtz;
    private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
    private final boolean authenticateAnnotatedOnly;
    private final boolean useAbortWith;

    FeatureConfig() {
        this.debug = false;
        this.authorizeAnnotatedOnly = false;
        this.usePrematchingAtn = false;
        this.usePrematchingAtz = false;
        this.authenticateAnnotatedOnly = true;
        this.useAbortWith = true;
    }

    FeatureConfig(SecurityFeature.Builder builder) {
        this.debug = builder.isDebug();
        this.authorizeAnnotatedOnly = builder.isAuthorizeAnnotatedOnly();
        this.authenticateAnnotatedOnly = builder.isAuthenticateAnnotatedOnly();
        this.usePrematchingAtz = builder.isPrematchingAuthorization();
        this.usePrematchingAtn = this.usePrematchingAtz ? true : builder.isPrematchingAuthentication();
        this.queryParamHandlers.addAll(builder.queryParamHandlers());
        this.useAbortWith = builder.useAbortWith();
    }

    boolean shouldAuthorizeAnnotatedOnly() {
        return this.authorizeAnnotatedOnly;
    }

    boolean shouldAuthenticateAnnotatedOnly() {
        return this.authenticateAnnotatedOnly;
    }

    List<QueryParamHandler> getQueryParamHandlers() {
        return Collections.unmodifiableList(this.queryParamHandlers);
    }

    boolean isDebug() {
        return this.debug;
    }

    public boolean shouldUsePrematchingAuthentication() {
        return this.usePrematchingAtn;
    }

    public boolean shouldUsePrematchingAuthorization() {
        return this.usePrematchingAtz;
    }

    public boolean useAbortWith() {
        return this.useAbortWith;
    }

    public String toString() {
        return "FeatureConfig(" + this.authorizeAnnotatedOnly + ", " + this.queryParamHandlers.size() + ", debug:" + this.debug + ")";
    }
}

