/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

class RequestedCounter {
    private final AtomicLong requested = new AtomicLong();

    RequestedCounter() {
    }

    public void increment(long increment, Consumer<? super IllegalArgumentException> errorHandler) {
        if (increment <= 0L) {
            errorHandler.accept(new IllegalArgumentException("Unsupported requested event increment: " + increment));
            return;
        }
        this.requested.updateAndGet(original -> {
            if (original == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            long r = original + increment;
            if (r == Long.MAX_VALUE || ((original ^ r) & (increment ^ r)) < 0L) {
                return Long.MAX_VALUE;
            }
            return r;
        });
    }

    public boolean tryDecrement() {
        return this.requested.getAndUpdate(val -> val > 0L ? val - 1L : 0L) > 0L;
    }

    public long get() {
        return this.requested.get();
    }
}

