/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.common.context.Contexts;
import io.helidon.security.SecurityContext;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.security.integration.jersey.SecurityDefinition;
import io.helidon.security.integration.jersey.SecurityFilterCommon;
import io.opentracing.SpanContext;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Ref;

@PreMatching
@Priority(value=1000)
@ConstrainedTo(value=RuntimeType.SERVER)
class SecurityPreMatchingFilter
extends SecurityFilterCommon
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(SecurityPreMatchingFilter.class.getName());
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger();
    @Context
    private InjectionManager injectionManager;
    @Context
    private UriInfo uriInfo;

    SecurityPreMatchingFilter() {
    }

    public void filter(ContainerRequestContext request) {
        SecurityTracing tracing = SecurityTracing.get();
        SecurityContext securityContext = this.security().contextBuilder(Integer.toString(CONTEXT_COUNTER.incrementAndGet(), 36)).tracingSpan((SpanContext)tracing.findParent().orElse(null)).build();
        Contexts.context().ifPresent(ctx -> ctx.register((Object)securityContext));
        ((Ref)this.injectionManager.getInstance(new GenericType<Ref<SecurityContext>>(){}.getType())).set((Object)securityContext);
        if (this.featureConfig().shouldUsePrematchingAuthentication()) {
            this.doFilter(request, securityContext);
        }
    }

    @Override
    protected void processSecurity(ContainerRequestContext request, SecurityFilterCommon.FilterContext filterContext, SecurityTracing tracing, SecurityContext securityContext) {
        this.authenticate(filterContext, securityContext, tracing.atnTracing());
        LOGGER.finest(() -> "Filter after authentication. Should finish: " + filterContext.isShouldFinish());
        if (filterContext.isShouldFinish()) {
            return;
        }
        filterContext.clearTrace();
        if (this.featureConfig().shouldUsePrematchingAuthorization()) {
            LOGGER.finest(() -> "Using pre-matching authorization");
            this.authorize(filterContext, securityContext, tracing.atzTracing());
        }
        LOGGER.finest(() -> "Filter completed (after authorization)");
    }

    @Override
    protected SecurityFilterCommon.FilterContext initRequestFiltering(ContainerRequestContext requestContext) {
        SecurityFilterCommon.FilterContext context = new SecurityFilterCommon.FilterContext();
        SecurityDefinition methodDef = new SecurityDefinition(false);
        methodDef.requiresAuthentication(true);
        methodDef.setRequiresAuthorization(this.featureConfig().shouldUsePrematchingAuthorization());
        context.setMethodSecurity(methodDef);
        context.setResourceName("jax-rs");
        return this.configureContext(context, requestContext, this.uriInfo);
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }
}

