/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpsign;

import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import io.helidon.security.SubjectType;
import io.helidon.security.providers.httpsign.HttpSignatureException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class InboundClientDefinition {
    private final String keyId;
    private final String principalName;
    private final SubjectType subjectType;
    private final String algorithm;
    private final KeyConfig keyConfig;
    private final byte[] hmacSharedSecret;

    private InboundClientDefinition(Builder builder) {
        this.keyId = builder.keyId;
        this.algorithm = builder.algorithm;
        this.keyConfig = builder.keyConfig;
        this.hmacSharedSecret = builder.hmacSharedSecret;
        this.principalName = builder.principalName;
        this.subjectType = builder.subjectType;
        Objects.requireNonNull(this.algorithm, "Signature algorithm must not be null");
        Objects.requireNonNull(this.keyId, "Key id must not be null");
        Objects.requireNonNull(this.principalName, "Principal name must not be null");
        Objects.requireNonNull(this.subjectType, "Principal type must not be null");
        if ("hmac-sha256".equals(this.algorithm)) {
            Objects.requireNonNull(this.hmacSharedSecret, "HMAC shared secret must not be null");
        } else if ("rsa-sha256".equals(this.algorithm)) {
            Objects.requireNonNull(this.keyConfig, "RSA Keys configuration must not be null");
        }
    }

    public static Builder builder(String keyId) {
        return new Builder().keyId(keyId);
    }

    public static Builder builder(Config config) {
        return new Builder().config(config);
    }

    public static InboundClientDefinition create(Config config) {
        return new Builder().config(config).build();
    }

    public String keyId() {
        return this.keyId;
    }

    public String principalName() {
        return this.principalName;
    }

    public SubjectType subjectType() {
        return this.subjectType;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public Optional<KeyConfig> keyConfig() {
        return Optional.ofNullable(this.keyConfig);
    }

    public Optional<byte[]> hmacSharedSecret() {
        return Optional.ofNullable(this.hmacSharedSecret);
    }

    public static final class Builder
    implements io.helidon.common.Builder<InboundClientDefinition> {
        private String keyId;
        private String algorithm;
        private KeyConfig keyConfig;
        private byte[] hmacSharedSecret;
        private String principalName;
        private SubjectType subjectType = SubjectType.SERVICE;

        private Builder() {
        }

        public Builder principalName(String name) {
            this.principalName = name;
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            if (this.principalName == null) {
                this.principalName = keyId;
            }
            return this;
        }

        public Builder subjectType(SubjectType type) {
            this.subjectType = type;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder publicKeyConfig(KeyConfig keyConfig) {
            if (null == this.algorithm) {
                this.algorithm = "rsa-sha256";
            }
            keyConfig.publicKey().orElseThrow(() -> new HttpSignatureException("Configuration must contain a public key"));
            this.keyConfig = keyConfig;
            return this;
        }

        public Builder hmacSecret(byte[] secret) {
            if (null == this.algorithm) {
                this.algorithm = "hmac-sha256";
            }
            this.hmacSharedSecret = Arrays.copyOf(secret, secret.length);
            return this;
        }

        public Builder hmacSecret(String secret) {
            return this.hmacSecret(secret.getBytes(StandardCharsets.UTF_8));
        }

        public InboundClientDefinition build() {
            return new InboundClientDefinition(this);
        }

        public Builder config(Config config) {
            this.keyId((String)config.get("key-id").asString().get());
            config.get("principal-name").asString().ifPresent(this::principalName);
            config.get("principal-type").asString().as(SubjectType::valueOf).ifPresent(this::subjectType);
            config.get("public-key").as(KeyConfig::create).ifPresent(this::publicKeyConfig);
            config.get("hmac.secret").asString().ifPresent(this::hmacSecret);
            config.get("algorithm").asString().ifPresent(this::algorithm);
            return this;
        }
    }
}

