/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpsign;

import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import io.helidon.security.providers.httpsign.HttpSignHeader;
import io.helidon.security.providers.httpsign.HttpSignProvider;
import io.helidon.security.providers.httpsign.HttpSignatureException;
import io.helidon.security.providers.httpsign.SignedHeadersConfig;
import io.helidon.security.util.TokenHandler;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

public final class OutboundTargetDefinition {
    private final String keyId;
    private final String algorithm;
    private final KeyConfig keyConfig;
    private final HttpSignHeader header;
    private final byte[] hmacSharedSecret;
    private final SignedHeadersConfig signedHeadersConfig;
    private final TokenHandler tokenHandler;
    private final boolean backwardCompatibleEol;

    private OutboundTargetDefinition(Builder builder) {
        this.keyId = builder.keyId;
        this.algorithm = builder.algorithm;
        this.keyConfig = builder.keyConfig;
        this.header = builder.header;
        this.hmacSharedSecret = builder.hmacSharedSecret;
        this.signedHeadersConfig = builder.signedHeadersConfig;
        this.tokenHandler = builder.tokenHandler;
        this.backwardCompatibleEol = builder.backwardCompatibleEol;
        Objects.requireNonNull(this.algorithm, "Signature algorithm must not be null");
        Objects.requireNonNull(this.keyId, "Key id must not be null");
        Objects.requireNonNull(this.header, "Header to use must not be null");
        Objects.requireNonNull(this.signedHeadersConfig, "Configuration of how to sign headers must not be null");
        if ("hmac-sha256".equals(this.algorithm)) {
            Objects.requireNonNull(this.hmacSharedSecret, "HMAC shared secret must not be null");
        } else if ("rsa-sha256".equals(this.algorithm)) {
            Objects.requireNonNull(this.keyConfig, "RSA Keys configuration must not be null");
        }
    }

    public static Builder builder(String keyId) {
        return new Builder().keyId(keyId);
    }

    public static Builder builder(Config config) {
        return new Builder().config(config);
    }

    public static OutboundTargetDefinition create(Config config) {
        return OutboundTargetDefinition.builder(config).build();
    }

    public String keyId() {
        return this.keyId;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public Optional<KeyConfig> keyConfig() {
        return Optional.ofNullable(this.keyConfig);
    }

    public Optional<byte[]> hmacSharedSecret() {
        return Optional.ofNullable(this.hmacSharedSecret);
    }

    public HttpSignHeader header() {
        return this.header;
    }

    public SignedHeadersConfig signedHeadersConfig() {
        return this.signedHeadersConfig;
    }

    public TokenHandler tokenHandler() {
        return this.tokenHandler;
    }

    public boolean backwardCompatibleEol() {
        return this.backwardCompatibleEol;
    }

    public static final class Builder
    implements io.helidon.common.Builder<OutboundTargetDefinition> {
        private static final Logger LOGGER = Logger.getLogger(Builder.class.getName());
        private String keyId;
        private String algorithm;
        private KeyConfig keyConfig;
        private HttpSignHeader header = HttpSignHeader.SIGNATURE;
        private byte[] hmacSharedSecret;
        private SignedHeadersConfig signedHeadersConfig = HttpSignProvider.DEFAULT_REQUIRED_HEADERS;
        private TokenHandler tokenHandler;
        @Deprecated
        private boolean backwardCompatibleEol = true;

        private Builder() {
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder header(HttpSignHeader header) {
            this.header = header;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder privateKeyConfig(KeyConfig keyConfig) {
            if (null == this.algorithm) {
                this.algorithm = "rsa-sha256";
            }
            keyConfig.privateKey().orElseThrow(() -> new HttpSignatureException("Configuration must contain a private key"));
            this.keyConfig = keyConfig;
            return this;
        }

        public Builder signedHeaders(SignedHeadersConfig config) {
            this.signedHeadersConfig = config;
            return this;
        }

        public Builder hmacSecret(byte[] secret) {
            if (null == this.algorithm) {
                this.algorithm = "hmac-sha256";
            }
            this.hmacSharedSecret = Arrays.copyOf(secret, secret.length);
            return this;
        }

        public Builder hmacSecret(String secret) {
            return this.hmacSecret(secret.getBytes(StandardCharsets.UTF_8));
        }

        public Builder tokenHandler(TokenHandler tokenHandler) {
            this.tokenHandler = tokenHandler;
            this.header = HttpSignHeader.CUSTOM;
            return this;
        }

        public OutboundTargetDefinition build() {
            if (this.backwardCompatibleEol) {
                LOGGER.warning("HTTP signatures is using legacy HTTP signature processing. This will not work with third party tools using the same spec and with Helidon newer than 3.0.0. Please configure 'backward-compatible-eol' to false to use the correct approach.");
            }
            return new OutboundTargetDefinition(this);
        }

        public Builder config(Config config) {
            Builder builder = new Builder();
            builder.keyId((String)config.get("key-id").asString().get());
            config.get("header").asString().map(HttpSignHeader::valueOf).ifPresent(builder::header);
            config.get("sign-headers").as(SignedHeadersConfig::create).ifPresent(builder::signedHeaders);
            config.get("private-key").as(KeyConfig::create).ifPresent(builder::privateKeyConfig);
            config.get("hmac.secret").asString().ifPresent(builder::hmacSecret);
            config.get("algorithm").asString().ifPresent(builder::algorithm);
            config.get("backward-compatible-eol").asBoolean().ifPresent(this::backwardCompatibleEol);
            return builder;
        }

        public Builder backwardCompatibleEol(Boolean backwardCompatible) {
            this.backwardCompatibleEol = backwardCompatible;
            return this;
        }
    }
}

