/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.config.Config;
import io.helidon.security.ProviderRequest;
import io.helidon.security.providers.oidc.common.spi.TenantIdFinder;
import io.helidon.security.providers.oidc.common.spi.TenantIdProvider;
import io.helidon.security.util.TokenHandler;
import jakarta.annotation.Priority;
import java.util.List;
import java.util.Optional;

@Priority(value=100000)
class DefaultTenantIdProvider
implements TenantIdProvider {
    static final String DEFAULT_TENANT_ID_STYLE = "host-header";
    static final Optional<String> DEFAULT_TENANT_ID_VALUE = Optional.of("@default");

    DefaultTenantIdProvider() {
    }

    public TenantIdFinder createTenantIdFinder(Config config) {
        boolean multiTenant = (Boolean)config.get("multi-tenant").asBoolean().orElse((Object)false);
        if (multiTenant) {
            String mtIdLookup;
            switch (mtIdLookup = (String)config.get("tenant-id-style").asString().orElse((Object)DEFAULT_TENANT_ID_STYLE)) {
                case "host-header": {
                    return new HostHeaderTenantId();
                }
                case "token-handler": {
                    return new TokenHandlerTenantId(TokenHandler.create((Config)config.get("tenant-id-handler")));
                }
                case "domain": {
                    return new DomainTenantId((Integer)config.get("tenant-id-domain-level").asInt().orElse((Object)3));
                }
                case "none": {
                    return new NoTenantId();
                }
            }
            throw new IllegalArgumentException("Invalid configuration of multi tenancy id style. Type " + mtIdLookup + " is not supported");
        }
        return new NoTenantId();
    }

    private static class HostHeaderTenantId
    implements TenantIdFinder {
        private HostHeaderTenantId() {
        }

        public Optional<String> tenantId(ProviderRequest providerRequest) {
            List hostList = (List)providerRequest.env().headers().get("host");
            if (hostList == null || hostList.isEmpty()) {
                return Optional.empty();
            }
            String host = (String)hostList.get(0);
            int index = host.indexOf(58);
            if (index == -1) {
                return Optional.of(host);
            }
            return Optional.of(host.substring(0, index));
        }
    }

    private static class TokenHandlerTenantId
    implements TenantIdFinder {
        private final TokenHandler tokenHandler;

        TokenHandlerTenantId(TokenHandler tokenHandler) {
            this.tokenHandler = tokenHandler;
        }

        public Optional<String> tenantId(ProviderRequest providerRequest) {
            return this.tokenHandler.extractToken(providerRequest.env().headers());
        }
    }

    private static class DomainTenantId
    implements TenantIdFinder {
        private final HostHeaderTenantId host = new HostHeaderTenantId();
        private final int level;

        private DomainTenantId(int level) {
            this.level = level;
        }

        public Optional<String> tenantId(ProviderRequest providerRequest) {
            return this.host.tenantId(providerRequest).flatMap(host -> {
                String[] split = host.split("\\.");
                int index = split.length - this.level;
                if (index >= 0 && index < split.length) {
                    return Optional.of(split[index]);
                }
                return Optional.empty();
            });
        }
    }

    private static class NoTenantId
    implements TenantIdFinder {
        private NoTenantId() {
        }

        public Optional<String> tenantId(ProviderRequest providerRequest) {
            return DEFAULT_TENANT_ID_VALUE;
        }
    }
}

