/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jersey.client;

import io.helidon.common.context.Contexts;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.tracing.jersey.client.internal.TracingContext;
import io.helidon.tracing.spi.TracerProvider;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.TreeMap;

@Priority(value=750)
public class ClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String JAX_RS_TRACING_COMPONENT = "jax-rs";
    public static final String TRACER_PROPERTY_NAME = "io.helidon.tracing.tracer";
    public static final String SPAN_NAME_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span-name";
    public static final String ENABLED_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span-enabled";
    public static final String CURRENT_SPAN_CONTEXT_PROPERTY_NAME = "io.helidon.tracing.span-context";
    public static final String X_OT_SPAN_CONTEXT = "x-ot-span-context";
    public static final String X_REQUEST_ID = "x-request-id";
    static final String SPAN_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span";
    static final String SPAN_SCOPE_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span-scope";
    private static final String SPAN_OPERATION_NAME = "jersey-client-call";
    private static final List<String> PROPAGATED_HEADERS = List.of("x-request-id", "x-ot-span-context");
    private static final int HTTP_STATUS_ERROR_THRESHOLD = 400;
    private static final int HTTP_STATUS_SERVER_ERROR_THRESHOLD = 500;
    private final Optional<TracerProvider> tracerProvider;

    public ClientTracingFilter() {
        Iterator iterator = HelidonServiceLoader.create(ServiceLoader.load(TracerProvider.class)).iterator();
        this.tracerProvider = iterator.hasNext() ? Optional.of((TracerProvider)iterator.next()) : Optional.empty();
    }

    public void filter(ClientRequestContext requestContext) {
        Optional<TracingContext> tracingContext = Contexts.context().flatMap(ctx -> ctx.get(TracingContext.class));
        if (this.tracingDisabled(requestContext, tracingContext)) {
            return;
        }
        SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)JAX_RS_TRACING_COMPONENT, (String)SPAN_OPERATION_NAME);
        if (!spanConfig.enabled()) {
            return;
        }
        Tracer tracer = this.findTracer(requestContext, tracingContext);
        Optional<SpanContext> parentSpan = this.findParentSpan(requestContext, tracingContext);
        Map<String, List<String>> inboundHeaders = this.findInboundHeaders(tracingContext);
        String spanName = this.findSpanName(requestContext, spanConfig);
        Span currentSpan = this.createSpan(requestContext, tracer, parentSpan, spanName);
        Scope spanScope = currentSpan.activate();
        requestContext.setProperty(SPAN_PROPERTY_NAME, (Object)currentSpan);
        requestContext.setProperty(SPAN_SCOPE_PROPERTY_NAME, (Object)spanScope);
        Contexts.context().ifPresent(ctx -> ctx.register((Object)SPAN_PROPERTY_NAME, (Object)currentSpan));
        Contexts.context().ifPresent(ctx -> ctx.register(TracingConfigUtil.OUTBOUND_SPAN_QUALIFIER, (Object)currentSpan.context()));
        Map<String, List<String>> outboundHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        HeaderProvider provider = HeaderProvider.create(inboundHeaders);
        HeaderConsumer consumer = HeaderConsumer.create(outboundHeaders);
        this.tracingHeaders(tracer, currentSpan, provider, consumer);
        outboundHeaders = this.updateOutboundHeaders(outboundHeaders, inboundHeaders);
        MultivaluedMap headers = requestContext.getHeaders();
        outboundHeaders.forEach((key, value) -> headers.put(key, new ArrayList(value)));
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        Object spanProperty = requestContext.getProperty(SPAN_PROPERTY_NAME);
        Object scopeProperty = requestContext.getProperty(SPAN_SCOPE_PROPERTY_NAME);
        if (spanProperty instanceof Span) {
            Span span = (Span)spanProperty;
            int status = responseContext.getStatus();
            Tag.HTTP_STATUS.create((Object)status).apply(span);
            if (status >= 400) {
                span.status(Span.Status.ERROR);
                span.addEvent("error", Map.of("message", "Response HTTP status: " + status, "error.kind", status < 500 ? "ClientError" : "ServerError"));
            }
            if (scopeProperty instanceof Scope) {
                Scope scope = (Scope)scopeProperty;
                scope.close();
            }
            span.end();
            requestContext.removeProperty(SPAN_SCOPE_PROPERTY_NAME);
            requestContext.removeProperty(SPAN_PROPERTY_NAME);
        }
    }

    private static <T> Optional<T> property(ClientRequestContext requestContext, Class<T> clazz, String propertyName) {
        return Optional.ofNullable(requestContext.getProperty(propertyName)).filter(clazz::isInstance).or(() -> Optional.ofNullable(requestContext.getConfiguration().getProperty(propertyName)).filter(clazz::isInstance)).map(clazz::cast);
    }

    private boolean tracingDisabled(ClientRequestContext requestContext, Optional<TracingContext> tracingContext) {
        Optional<Boolean> enabled = ClientTracingFilter.property(requestContext, Boolean.class, ENABLED_PROPERTY_NAME);
        if (enabled.isPresent() && !enabled.get().booleanValue()) {
            return true;
        }
        return tracingContext.map(TracingContext::traceClient).map(value -> value == false).orElse(false);
    }

    private Map<String, List<String>> findInboundHeaders(Optional<TracingContext> tracingContext) {
        return tracingContext.map(TracingContext::inboundHeaders).orElse(Map.of());
    }

    private Map<String, List<String>> updateOutboundHeaders(Map<String, List<String>> outboundHeaders, Map<String, List<String>> inboundHeaders) {
        if (inboundHeaders.isEmpty()) {
            return outboundHeaders;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(outboundHeaders);
        PROPAGATED_HEADERS.forEach(header -> result.computeIfAbsent((String)header, inboundHeaders::get));
        return result;
    }

    private Optional<SpanContext> findParentSpan(ClientRequestContext requestContext, Optional<TracingContext> tracingContext) {
        Optional<SpanContext> property = ClientTracingFilter.property(requestContext, SpanContext.class, CURRENT_SPAN_CONTEXT_PROPERTY_NAME);
        if (property.isPresent()) {
            return property;
        }
        return Span.current().map(Span::context).or(() -> tracingContext.map(TracingContext::parentSpan).or(() -> Contexts.context().flatMap(ctx -> ctx.get(ClientTracingFilter.class, SpanContext.class))).or(() -> Contexts.context().flatMap(ctx -> ctx.get(SpanContext.class))));
    }

    private String findSpanName(ClientRequestContext requestContext, SpanTracingConfig spanConfig) {
        return ClientTracingFilter.property(requestContext, String.class, SPAN_NAME_PROPERTY_NAME).or(() -> ((SpanTracingConfig)spanConfig).newName()).orElseGet(() -> requestContext.getMethod().toUpperCase());
    }

    private Tracer findTracer(ClientRequestContext requestContext, Optional<TracingContext> tracingContext) {
        return ClientTracingFilter.property(requestContext, Tracer.class, TRACER_PROPERTY_NAME).or(() -> tracingContext.map(TracingContext::tracer)).or(() -> Contexts.context().flatMap(ctx -> ctx.get(Tracer.class))).orElseGet(Tracer::global);
    }

    private void tracingHeaders(Tracer tracer, Span currentSpan, HeaderProvider provider, HeaderConsumer consumer) {
        tracer.inject(currentSpan.context(), provider, consumer);
    }

    private Span createSpan(ClientRequestContext requestContext, Tracer tracer, Optional<SpanContext> parentSpan, String spanName) {
        Span.Builder spanBuilder = tracer.spanBuilder(spanName).kind(Span.Kind.CLIENT).tag(Tag.HTTP_METHOD.create((Object)requestContext.getMethod())).tag(Tag.HTTP_URL.create((Object)this.url(requestContext.getUri()))).tag(Tag.COMPONENT.create((Object)"jaxrs"));
        parentSpan.ifPresent(arg_0 -> ((Span.Builder)spanBuilder).parent(arg_0));
        return spanBuilder.start();
    }

    private String url(URI uri) {
        String host = uri.getHost();
        host = host.replace("127.0.0.1", "localhost");
        Object query = uri.getQuery();
        if (null == query) {
            query = "";
        } else if (!((String)query).isEmpty()) {
            query = "?" + (String)query;
        }
        return uri.getScheme() + "://" + host + ":" + uri.getPort() + uri.getPath() + (String)query;
    }
}

