/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.tracing.Span;
import java.util.Objects;

public abstract class Tag<T> {
    public static final TagSource<String> COMPONENT = new StringTagSource("component");
    public static final TagSource<String> HTTP_METHOD = new StringTagSource("http.method");
    public static final TagSource<String> HTTP_URL = new StringTagSource("http.url");
    public static final TagSource<String> HTTP_VERSION = new StringTagSource("http.version");
    public static final TagSource<Integer> HTTP_STATUS = new NumberTagSource<Integer>("http.status_code");
    public static final TagSource<String> DB_TYPE = new StringTagSource("db.type");
    public static final TagSource<String> DB_STATEMENT = new StringTagSource("db.statement");
    private final String key;
    private final T value;

    public static Tag<String> create(String key, String value) {
        return new StringTag(key, value);
    }

    public static Tag<Number> create(String key, Number value) {
        return new NumericTag(key, value);
    }

    public static Tag<Boolean> create(String key, boolean value) {
        return new BooleanTag(key, value);
    }

    public String key() {
        return this.key;
    }

    public T value() {
        return this.value;
    }

    private Tag(String key, T value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        return this.key.equals(tag.key) && this.value.equals(tag.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public abstract void apply(Span var1);

    public abstract void apply(Span.Builder<?> var1);

    private static final class StringTag
    extends Tag<String> {
        private StringTag(String key, String value) {
            super(key, value);
        }

        @Override
        public void apply(Span span) {
            span.tag(this.key(), (String)this.value());
        }

        @Override
        public void apply(Span.Builder<?> spanBuilder) {
            spanBuilder.tag(this.key(), (String)this.value());
        }
    }

    private static final class NumericTag
    extends Tag<Number> {
        private NumericTag(String key, Number value) {
            super(key, value);
        }

        @Override
        public void apply(Span span) {
            span.tag(this.key(), (Number)this.value());
        }

        @Override
        public void apply(Span.Builder<?> spanBuilder) {
            spanBuilder.tag(this.key(), (Number)this.value());
        }
    }

    private static final class BooleanTag
    extends Tag<Boolean> {
        private BooleanTag(String key, boolean value) {
            super(key, value);
        }

        @Override
        public void apply(Span span) {
            span.tag(this.key(), (Boolean)this.value());
        }

        @Override
        public void apply(Span.Builder<?> spanBuilder) {
            spanBuilder.tag(this.key(), (Boolean)this.value());
        }
    }

    private static class StringTagSource
    implements TagSource<String> {
        private final String name;

        protected StringTagSource(String name) {
            this.name = name;
        }

        @Override
        public Tag<String> create(String value) {
            return new StringTag(this.name, value);
        }
    }

    public static interface TagSource<T> {
        public Tag<? super T> create(T var1);
    }

    private static class NumberTagSource<T extends Number>
    implements TagSource<T> {
        private final String name;

        protected NumberTagSource(String name) {
            this.name = name;
        }

        @Override
        public Tag<Number> create(T value) {
            return new NumericTag(this.name, (Number)value);
        }
    }

    private static class BooleanTagSource
    implements TagSource<Boolean> {
        private final String component;

        protected BooleanTagSource(String component) {
            this.component = component;
        }

        @Override
        public Tag<Boolean> create(Boolean value) {
            return new BooleanTag(this.component, value);
        }
    }
}

