/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.NoOpTracer;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.TracerProviderHelper;
import java.util.Optional;

public interface Tracer {
    public static Tracer noOp() {
        return NoOpTracer.instance();
    }

    public static Tracer global() {
        return TracerProviderHelper.global();
    }

    public static void global(Tracer tracer) {
        TracerProviderHelper.global(tracer);
    }

    public boolean enabled();

    public Span.Builder<?> spanBuilder(String var1);

    public Optional<SpanContext> extract(HeaderProvider var1);

    public void inject(SpanContext var1, HeaderProvider var2, HeaderConsumer var3);

    default public <T> T unwrap(Class<T> tracerClass) {
        try {
            return tracerClass.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("This tracer is not compatible with " + tracerClass.getName());
        }
    }
}

