/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.tracing.NoOpTracerProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.tracing.spi.TracerProvider;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

final class TracerProviderHelper {
    private static final System.Logger LOGGER = System.getLogger(TracerProviderHelper.class.getName());
    private static final TracerProvider TRACER_PROVIDER;

    private TracerProviderHelper() {
    }

    public static Optional<Span> currentSpan() {
        return TRACER_PROVIDER == null ? Optional.empty() : TRACER_PROVIDER.currentSpan();
    }

    static Tracer global() {
        if (TRACER_PROVIDER == null) {
            throw new IllegalStateException("Use before initialization has completed");
        }
        return TRACER_PROVIDER.global();
    }

    static void global(Tracer tracer) {
        if (TRACER_PROVIDER == null) {
            throw new IllegalStateException("Use before initialization has completed");
        }
        TRACER_PROVIDER.global(tracer);
    }

    static TracerBuilder<?> findTracerBuilder() {
        if (TRACER_PROVIDER == null) {
            throw new IllegalStateException("Use before initialization has completed");
        }
        return TRACER_PROVIDER.createBuilder();
    }

    static {
        TracerProvider provider = null;
        try {
            List allProviders = HelidonServiceLoader.builder(ServiceLoader.load(TracerProvider.class)).addService((Object)new NoOpTracerProvider(), 100000).build().asList();
            if (allProviders.size() == 1 || allProviders.size() == 2) {
                provider = (TracerProvider)allProviders.get(0);
            }
            for (TracerProvider aProvider : allProviders) {
                if (!aProvider.available()) continue;
                provider = aProvider;
                break;
            }
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, "Failed to set up tracer provider, using no-op", e);
        }
        TRACER_PROVIDER = provider == null ? new NoOpTracerProvider() : provider;
    }
}

