/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.webserver.cors.CorsSetter;
import io.helidon.webserver.cors.Loader;
import java.util.Arrays;

public class CrossOriginConfig {
    public static final String CORS_PATHS_CONFIG_KEY = "paths";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final long DEFAULT_AGE = 3600L;
    private final String pathPattern;
    private final boolean enabled;
    private final String[] allowOrigins;
    private final String[] allowHeaders;
    private final String[] exposeHeaders;
    private final String[] allowMethods;
    private final boolean allowCredentials;
    private final long maxAgeSeconds;

    private CrossOriginConfig(Builder builder) {
        this.pathPattern = builder.pathPattern;
        this.enabled = builder.enabled;
        this.allowOrigins = builder.origins;
        this.allowHeaders = builder.allowHeaders;
        this.exposeHeaders = builder.exposeHeaders;
        this.allowMethods = builder.allowMethods;
        this.allowCredentials = builder.allowCredentials;
        this.maxAgeSeconds = builder.maxAgeSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        return Loader.Basic.applyConfig(CrossOriginConfig.builder(), config);
    }

    public static Builder builder(CrossOriginConfig original) {
        return new Builder().pathPattern(original.pathPattern).enabled(original.enabled).allowCredentials(original.allowCredentials).allowHeaders(original.allowHeaders).allowMethods(original.allowMethods).allowOrigins(original.allowOrigins).exposeHeaders(original.exposeHeaders).maxAgeSeconds(original.maxAgeSeconds);
    }

    public static CrossOriginConfig create() {
        return CrossOriginConfig.builder().build();
    }

    public static CrossOriginConfig create(Config corsConfig) {
        return CrossOriginConfig.builder(corsConfig).build();
    }

    public String pathPattern() {
        return this.pathPattern;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String[] allowOrigins() {
        return CrossOriginConfig.copyOf(this.allowOrigins);
    }

    public String[] allowHeaders() {
        return CrossOriginConfig.copyOf(this.allowHeaders);
    }

    public String[] exposeHeaders() {
        return CrossOriginConfig.copyOf(this.exposeHeaders);
    }

    public String[] allowMethods() {
        return CrossOriginConfig.copyOf(this.allowMethods);
    }

    public boolean allowCredentials() {
        return this.allowCredentials;
    }

    public long maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public boolean matches(String method) {
        for (String allowMethod : this.allowMethods) {
            if (!allowMethod.equalsIgnoreCase(method) && !allowMethod.equals("*")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("CrossOriginConfig{pathPattern=%s, enabled=%b, origins=%s, allowHeaders=%s, exposeHeaders=%s, allowMethods=%s, allowCredentials=%b, maxAgeSeconds=%d", this.pathPattern, this.enabled, Arrays.toString(this.allowOrigins), Arrays.toString(this.allowHeaders), Arrays.toString(this.exposeHeaders), Arrays.toString(this.allowMethods), this.allowCredentials, this.maxAgeSeconds);
    }

    private static String[] copyOf(String[] strings) {
        return strings != null ? Arrays.copyOf(strings, strings.length) : new String[]{};
    }

    @Configured
    public static class Builder
    implements CorsSetter<Builder>,
    io.helidon.common.Builder<Builder, CrossOriginConfig> {
        static final String[] ALLOW_ALL = new String[]{"*"};
        private String pathPattern = "{+}";
        private boolean enabled = true;
        private String[] origins = ALLOW_ALL;
        private String[] allowHeaders = ALLOW_ALL;
        private String[] exposeHeaders;
        private String[] allowMethods = ALLOW_ALL;
        private boolean allowCredentials;
        private long maxAgeSeconds = 3600L;

        private Builder() {
        }

        public Builder pathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        String pathPattern() {
            return this.pathPattern;
        }

        @Override
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder allowOrigins(String ... origins) {
            this.origins = CrossOriginConfig.copyOf(origins);
            return this;
        }

        @Override
        public Builder allowHeaders(String ... allowHeaders) {
            this.allowHeaders = CrossOriginConfig.copyOf(allowHeaders);
            return this;
        }

        @Override
        public Builder exposeHeaders(String ... exposeHeaders) {
            this.exposeHeaders = CrossOriginConfig.copyOf(exposeHeaders);
            return this;
        }

        @Override
        public Builder allowMethods(String ... allowMethods) {
            this.allowMethods = CrossOriginConfig.copyOf(allowMethods);
            return this;
        }

        @Override
        public Builder allowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        @Override
        public Builder maxAgeSeconds(long maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public Builder config(Config corsConfig) {
            Loader.Basic.applyConfig(this, corsConfig);
            return this;
        }

        public CrossOriginConfig build() {
            return new CrossOriginConfig(this);
        }

        public String toString() {
            return String.format("Builder{pathPattern=%s, enabled=%b, origins=%s, allowHeaders=%s, exposeHeaders=%s, allowMethods=%s, allowCredentials=%b, maxAgeSeconds=%d", this.pathPattern, this.enabled, Arrays.toString(this.origins), Arrays.toString(this.allowHeaders), Arrays.toString(this.exposeHeaders), Arrays.toString(this.allowMethods), this.allowCredentials, this.maxAgeSeconds);
        }
    }
}

