/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.cors.CorsSupportBase;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

class RequestAdapterSe
implements CorsSupportBase.RequestAdapter<ServerRequest> {
    private final ServerRequest request;

    RequestAdapterSe(ServerRequest request) {
        this.request = request;
    }

    @Override
    public String path() {
        return this.request.path().toString();
    }

    @Override
    public Optional<String> firstHeader(String key) {
        return this.request.headers().first(key);
    }

    @Override
    public boolean headerContainsKey(String key) {
        return this.firstHeader(key).isPresent();
    }

    @Override
    public List<String> allHeaders(String key) {
        return this.request.headers().all(key);
    }

    @Override
    public String method() {
        return this.request.method().name();
    }

    @Override
    public void next() {
        this.request.next();
    }

    @Override
    public ServerRequest request() {
        return this.request;
    }

    public String toString() {
        return String.format("RequestAdapterSe{path=%s, method=%s, headers=%s}", this.path(), this.method(), this.headersDisplay());
    }

    private Map<String, List<String>> headersDisplay() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry header : this.request.headers().toMap().entrySet()) {
            if (!HEADERS_FOR_CORS_DIAGNOSTICS.contains(((String)header.getKey()).toLowerCase(Locale.getDefault()))) continue;
            result.put((String)header.getKey(), (List)header.getValue());
        }
        return result;
    }
}

