/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.jersey;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.config.Config;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.glassfish.jersey.server.ManagedAsyncExecutor;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

@ManagedAsyncExecutor
class AsyncExecutorProvider
implements ExecutorServiceProvider {
    private final Supplier<ExecutorService> executorServiceSupplier;

    AsyncExecutorProvider(Supplier<ExecutorService> supplier) {
        this.executorServiceSupplier = Objects.requireNonNull(supplier);
    }

    static ExecutorServiceProvider create(Config config) {
        Config asyncExecutorServiceConfig = config.get("async-executor-service");
        return new AsyncExecutorProvider((Supplier<ExecutorService>)ThreadPoolSupplier.builder().corePoolSize(1).maxPoolSize(10).prestart(false).threadNamePrefix("helidon-jersey-async").config(asyncExecutorServiceConfig).build());
    }

    static ExecutorServiceProvider create(ExecutorService executor) {
        return new AsyncExecutorProvider(() -> executor);
    }

    static ExecutorServiceProvider create(Supplier<ExecutorService> executorServiceSupplier) {
        return new AsyncExecutorProvider(executorServiceSupplier);
    }

    public ExecutorService getExecutorService() {
        return this.executorServiceSupplier.get();
    }

    public void dispose(ExecutorService executorService) {
    }
}

