/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.BadRequestException;
import io.helidon.webserver.BareRequestImpl;
import io.helidon.webserver.BareResponseImpl;
import io.helidon.webserver.ByteBufRequestChunk;
import io.helidon.webserver.HttpRequestScopedPublisher;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.helidon.webserver.RequestContext;
import io.helidon.webserver.Routing;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class ForwardingHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = Logger.getLogger(ForwardingHandler.class.getName());
    private static final AtomicLong REQUEST_ID_GENERATOR = new AtomicLong(0L);
    private final Routing routing;
    private final NettyWebServer webServer;
    private final SSLEngine sslEngine;
    private final Queue<ReferenceHoldingQueue<ByteBufRequestChunk>> queues;
    private RequestContext requestContext;

    ForwardingHandler(Routing routing, NettyWebServer webServer, SSLEngine sslEngine, Queue<ReferenceHoldingQueue<ByteBufRequestChunk>> queues) {
        this.routing = routing;
        this.webServer = webServer;
        this.sslEngine = sslEngine;
        this.queues = queues;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        if (this.requestContext == null) {
            return;
        }
        if (this.requestContext.publisher().tryAcquire() > 0L) {
            ctx.channel().read();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        LOGGER.fine(() -> String.format("[Handler: %s] Received object: %s", System.identityHashCode((Object)this), msg.getClass()));
        if (msg instanceof HttpRequest) {
            BareRequestImpl bareRequest;
            ctx.channel().config().setAutoRead(false);
            HttpRequest request = (HttpRequest)msg;
            ReferenceHoldingQueue<ByteBufRequestChunk> queue = new ReferenceHoldingQueue<ByteBufRequestChunk>();
            this.queues.add(queue);
            this.requestContext = new RequestContext(new HttpRequestScopedPublisher(ctx, queue), request);
            HttpRequestScopedPublisher publisherRef = this.requestContext.publisher();
            long requestId = REQUEST_ID_GENERATOR.incrementAndGet();
            try {
                bareRequest = new BareRequestImpl((HttpRequest)msg, this.requestContext.publisher(), this.webServer, ctx, this.sslEngine, requestId);
            }
            catch (IllegalArgumentException e) {
                ForwardingHandler.send400BadRequest(ctx, e.getMessage());
                return;
            }
            BareResponseImpl bareResponse = new BareResponseImpl(ctx, request, publisherRef::isCompleted, Thread.currentThread(), requestId);
            bareResponse.whenCompleted().thenRun(() -> {
                RequestContext requestContext = this.requestContext;
                if (requestContext != null) {
                    requestContext.responseCompleted(true);
                }
                if (queue.release()) {
                    this.queues.remove(queue);
                }
                ctx.channel().config().setAutoRead(true);
            });
            if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                ForwardingHandler.send100Continue(ctx);
            }
            this.routing.route(bareRequest, bareResponse);
        }
        if (msg instanceof HttpContent) {
            if (this.requestContext == null) {
                throw new IllegalStateException("There is no request context associated with this http content. This is never expected to happen!");
            }
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                HttpMethod method = this.requestContext.request().method();
                if (HttpMethod.TRACE.equals((Object)method)) {
                    LOGGER.finer(() -> "Closing connection because of an illegal payload; method: " + method);
                    throw new BadRequestException("It is illegal to send a payload with http method: " + method);
                }
                if (this.requestContext.responseCompleted() && !(msg instanceof LastHttpContent)) {
                    LOGGER.finer(() -> "Closing connection because request payload was not consumed; method: " + method);
                    ctx.close();
                } else {
                    this.requestContext.publisher().submit(content);
                }
            }
            if (msg instanceof LastHttpContent) {
                this.requestContext.publisher().complete();
                this.requestContext = null;
            } else if (!content.isReadable()) {
                throw new IllegalStateException("It is not expected to not have readable content.");
            }
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    private static void send400BadRequest(ChannelHandlerContext ctx, String message) {
        byte[] entity = message.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])entity));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)entity.length);
        ctx.write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.requestContext != null) {
            this.requestContext.publisher().error(cause);
        }
        ctx.close();
    }
}

