/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.Handler;
import io.helidon.webserver.PathTracingConfig;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.WebServer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class WebTracingConfig {
    abstract TracingConfig envConfig();

    abstract Iterable<PathTracingConfig> pathConfigs();

    public static WebTracingConfig create() {
        return WebTracingConfig.create(TracingConfig.ENABLED);
    }

    public static WebTracingConfig create(TracingConfig configuration) {
        return WebTracingConfig.builder().envConfig(configuration).build();
    }

    public static WebTracingConfig create(Config config) {
        return WebTracingConfig.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static Tracer tracer(WebServer webServer) {
        Tracer tracer;
        ServerConfiguration configuration;
        if (null != webServer && null != (configuration = webServer.configuration()) && null != (tracer = configuration.tracer())) {
            return tracer;
        }
        return Contexts.context().flatMap(ctx -> ctx.get(Tracer.class)).orElseGet(GlobalTracer::get);
    }

    Service service() {
        return rules -> {
            this.pathConfigs().forEach(path -> {
                List<Http.RequestMethod> methods = path.methods().stream().map(Http.RequestMethod::create).collect(Collectors.toList());
                TracingConfig wrappedPath = path.tracedConfig();
                if (methods.isEmpty()) {
                    rules.any(path.path(), new TracingConfigHandler(wrappedPath));
                } else {
                    rules.anyOf(methods, path.path(), new TracingConfigHandler(wrappedPath));
                }
            });
            rules.any(new RequestSpanHandler());
        };
    }

    private static final class RequestSpanHandler
    implements Handler {
        private static final String TRACING_SPAN_HTTP_REQUEST = "HTTP Request";

        private RequestSpanHandler() {
        }

        @Override
        public void accept(ServerRequest req, ServerResponse res) {
            this.doAccept(req, res);
            req.next();
        }

        private void doAccept(ServerRequest req, ServerResponse res) {
            Tracer tracer = req.tracer();
            Context context = (Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be available"));
            SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)TRACING_SPAN_HTTP_REQUEST);
            Map<String, String> headersMap = req.headers().toMap().entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
            SpanContext inboundSpanContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headersMap));
            if (null != inboundSpanContext) {
                context.register((Object)inboundSpanContext);
                context.register(ServerRequest.class, (Object)inboundSpanContext);
            }
            if (!spanConfig.enabled()) {
                return;
            }
            String spanName = spanConfig.newName().orElse(TRACING_SPAN_HTTP_REQUEST);
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName).withTag(Tags.COMPONENT.getKey(), "helidon-webserver").withTag(Tags.HTTP_METHOD.getKey(), req.method().name()).withTag(Tags.HTTP_URL.getKey(), req.uri().toString());
            if (inboundSpanContext != null) {
                spanBuilder.asChildOf(inboundSpanContext);
            }
            Span span = spanBuilder.start();
            context.register((Object)span);
            context.register(ServerRequest.class, (Object)span);
            context.register((Object)span.context());
            context.register(ServerRequest.class, (Object)span.context());
            res.whenSent().thenRun(() -> {
                Http.ResponseStatus httpStatus = res.status();
                if (httpStatus != null) {
                    int statusCode = httpStatus.code();
                    Tags.HTTP_STATUS.set(span, Integer.valueOf(statusCode));
                    if (statusCode >= 400) {
                        Tags.ERROR.set(span, Boolean.valueOf(true));
                        span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"message", (Object)("Response HTTP status: " + statusCode), (Object)"error.kind", (Object)(statusCode < 500 ? "ClientError" : "ServerError")));
                    }
                }
                span.finish();
            }).exceptionally(t -> {
                Tags.ERROR.set(span, Boolean.valueOf(true));
                span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"error.object", (Object)t));
                span.finish();
                return null;
            });
        }
    }

    private static final class TracingConfigHandler
    implements Handler {
        private final TracingConfig pathSpecific;

        private TracingConfigHandler(TracingConfig pathSpecific) {
            this.pathSpecific = pathSpecific;
        }

        @Override
        public void accept(ServerRequest req, ServerResponse res) {
            Optional existing = req.context().get(TracingConfig.class);
            if (existing.isPresent()) {
                req.context().register((Object)TracingConfig.merge((TracingConfig)((TracingConfig)existing.get()), (TracingConfig)this.pathSpecific));
            } else {
                req.context().register((Object)this.pathSpecific);
            }
            req.next();
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<WebTracingConfig> {
        private final List<PathTracingConfig> pathTracingConfigs = new LinkedList<PathTracingConfig>();
        private TracingConfig tracedConfig = TracingConfig.ENABLED;

        public WebTracingConfig build() {
            final TracingConfig envConfig = this.tracedConfig;
            final LinkedList<PathTracingConfig> pathConfigs = new LinkedList<PathTracingConfig>(this.pathTracingConfigs);
            return new WebTracingConfig(){

                @Override
                public TracingConfig envConfig() {
                    return envConfig;
                }

                @Override
                public Iterable<PathTracingConfig> pathConfigs() {
                    return pathConfigs;
                }
            };
        }

        public Builder addPathConfig(PathTracingConfig pathTracingConfig) {
            this.pathTracingConfigs.add(pathTracingConfig);
            return this;
        }

        public Builder envConfig(TracingConfig tracingConfig) {
            this.tracedConfig = tracingConfig;
            return this;
        }

        public Builder config(Config config) {
            this.envConfig(TracingConfig.create((Config)config));
            Config allPaths = config.get("paths");
            allPaths.asNodeList().ifPresent(this::addPaths);
            return this;
        }

        private void addPaths(List<Config> configs) {
            configs.stream().map(PathTracingConfig::create).forEach(this::addPathConfig);
        }
    }
}

