/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.logger;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.logger.Level;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u001c\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002J\u0012\u0010\u0010\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u0012\u0010\u0011\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0003J\u001c\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lorg/koin/core/logger/Logger;", "", "level", "Lorg/koin/core/logger/Level;", "(Lorg/koin/core/logger/Level;)V", "getLevel", "()Lorg/koin/core/logger/Level;", "setLevel", "canLog", "", "debug", "", "msg", "", "Lorg/koin/core/logger/MESSAGE;", "doLog", "error", "info", "isAt", "lvl", "log", "koin-core"})
public abstract class Logger {
    @NotNull
    private Level level;

    public Logger(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
    }

    public /* synthetic */ Logger(Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            level = Level.INFO;
        }
        this(level);
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.level = level;
    }

    public abstract void log(@NotNull Level var1, @NotNull String var2);

    private final boolean canLog(Level level) {
        return this.level.compareTo((Enum)level) <= 0;
    }

    private final void doLog(Level level, String msg) {
        if (this.canLog(level)) {
            this.log(level, msg);
        }
    }

    public final void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.doLog(Level.DEBUG, msg);
    }

    public final void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.doLog(Level.INFO, msg);
    }

    public final void error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.doLog(Level.ERROR, msg);
    }

    public final boolean isAt(@NotNull Level lvl) {
        Intrinsics.checkNotNullParameter((Object)((Object)lvl), (String)"lvl");
        return this.level.compareTo((Enum)lvl) <= 0;
    }

    public Logger() {
        this(null, 1, null);
    }
}

