/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BranchDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.ForkPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.OriginPullRequestDiscoveryTrait;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.TaskListener;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketCredentialUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.scm.api.AbstractMultiBranchCreateRequest;
import io.jenkins.blueocean.scm.api.AbstractScmSourceEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.git.traits.CleanAfterCheckoutTrait;
import jenkins.plugins.git.traits.CleanBeforeCheckoutTrait;
import jenkins.plugins.git.traits.LocalBranchTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketPipelineCreateRequest
extends AbstractMultiBranchCreateRequest {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketPipelineCreateRequest.class);

    @DataBoundConstructor
    public BitbucketPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        super(name, scmConfig);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    protected SCMSource createSource(@NonNull MultiBranchProject project, @NonNull BlueScmConfig scmConfig) {
        String url;
        if (StringUtils.isBlank((String)scmConfig.getUri())) {
            throw new ServiceException.BadRequestException("scmConfig.uri must be present");
        }
        HashSet<ChangeRequestCheckoutStrategy> strategies = new HashSet<ChangeRequestCheckoutStrategy>();
        strategies.add(ChangeRequestCheckoutStrategy.MERGE);
        BitbucketSCMSource bitbucketSCMSource = ((BitbucketSCMSourceBuilder)((BitbucketSCMSourceBuilder)((BitbucketSCMSourceBuilder)((BitbucketSCMSourceBuilder)((BitbucketSCMSourceBuilder)((BitbucketSCMSourceBuilder)new BitbucketSCMSourceBuilder(null, scmConfig.getUri(), this.computeCredentialId(scmConfig), (String)scmConfig.getConfig().get("repoOwner"), (String)scmConfig.getConfig().get("repository")).withTrait((SCMSourceTrait)new BranchDiscoveryTrait(true, true))).withTrait((SCMSourceTrait)new ForkPullRequestDiscoveryTrait(strategies, (SCMHeadAuthority)new ForkPullRequestDiscoveryTrait.TrustTeamForks()))).withTrait((SCMSourceTrait)new OriginPullRequestDiscoveryTrait(strategies))).withTrait((SCMSourceTrait)new CleanBeforeCheckoutTrait())).withTrait((SCMSourceTrait)new CleanAfterCheckoutTrait())).withTrait((SCMSourceTrait)new LocalBranchTrait())).build();
        JenkinsLocationConfiguration jenkinsLocationConfiguration = JenkinsLocationConfiguration.get();
        if (jenkinsLocationConfiguration != null && (url = jenkinsLocationConfiguration.getUrl()) == null && (url = Jenkins.get().getRootUrl()) != null) {
            jenkinsLocationConfiguration.setUrl(url);
        }
        return bitbucketSCMSource;
    }

    @Nullable
    protected AbstractScmSourceEvent getScmSourceEvent(final @NonNull MultiBranchProject project, @NonNull SCMSource source) {
        if (source instanceof BitbucketSCMSource) {
            return new AbstractScmSourceEvent(((BitbucketSCMSource)source).getRepository(), ((BitbucketSCMSource)source).getServerUrl()){

                public boolean isMatch(@NonNull SCMSource source) {
                    SCMSourceOwner sourceOwner = source.getOwner();
                    return ((BitbucketSCMSource)source).getRepository().equals(this.getSourceName()) && sourceOwner != null && sourceOwner.getFullName().equals(project.getFullName());
                }
            };
        }
        return null;
    }

    protected boolean repoHasJenkinsFile(@NonNull SCMSource scmSource) {
        final AbstractMultiBranchCreateRequest.JenkinsfileCriteria criteria = new AbstractMultiBranchCreateRequest.JenkinsfileCriteria();
        try {
            scmSource.fetch((SCMSourceCriteria)criteria, new SCMHeadObserver(){

                public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
                }

                public boolean isObserving() {
                    return !criteria.isJenkinsfileFound();
                }
            }, TaskListener.NULL);
        }
        catch (IOException | InterruptedException e) {
            logger.warn("Error detecting Jenkinsfile: " + e.getMessage(), (Throwable)e);
        }
        return criteria.isJenkinsfileFound();
    }

    protected List<ErrorMessage.Error> validate(String name, BlueScmConfig scmConfig) {
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        StandardUsernamePasswordCredentials credentials = null;
        String credentialId = this.computeCredentialId(scmConfig);
        if (credentialId != null) {
            credentials = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        }
        if (credentials == null) {
            errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.NOT_FOUND.toString(), "No Credentials instance found for credentialId: " + credentialId));
        }
        if (StringUtils.isBlank((String)((String)scmConfig.getConfig().get("repoOwner")))) {
            errors.add(new ErrorMessage.Error("scmConfig.repoOwner", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "repoOwner is required"));
        }
        if (StringUtils.isBlank((String)((String)scmConfig.getConfig().get("repository")))) {
            errors.add(new ErrorMessage.Error("scmConfig.repository", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "repository is required"));
        }
        if (StringUtils.isBlank((String)scmConfig.getUri())) {
            errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "uri is required"));
        }
        return errors;
    }

    protected String computeCredentialId(BlueScmConfig scmConfig) {
        return BitbucketCredentialUtils.computeCredentialId(scmConfig.getCredentialId(), scmConfig.getId(), scmConfig.getUri());
    }
}

