/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import java.util.Iterator;

public class PipelineStepContainerImpl
extends BluePipelineStepContainer {
    private final FlowNodeWrapper node;
    private final Link self;
    private final String runExternalizableId;

    public PipelineStepContainerImpl(FlowNodeWrapper node, Link parentLink, String runExternalizableId) {
        this.self = parentLink.rel("steps");
        this.node = node;
        this.runExternalizableId = runExternalizableId;
    }

    public PipelineStepContainerImpl(String runExternalizableId, Link parentLink) {
        this.self = parentLink.rel("steps");
        this.node = null;
        this.runExternalizableId = runExternalizableId;
    }

    public BluePipelineStep get(String name) {
        NodeGraphBuilder builder = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance(PipelineRunImpl.findRun(this.runExternalizableId));
        return builder.getPipelineNodeStep(name, this.getLink());
    }

    public Iterator<BluePipelineStep> iterator() {
        NodeGraphBuilder builder = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance(PipelineRunImpl.findRun(this.runExternalizableId));
        return this.node == null ? builder.getPipelineNodeSteps(this.getLink()).iterator() : builder.getPipelineNodeSteps(this.node.getId(), this.getLink()).iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

