/*
 * Decompiled with CFR 0.152.
 */
package io.blueocean.rest.pipeline.editor;

import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ExportedToolDescriptor {
    private final String toolName;
    private final String symbol;
    private final Class<?> type;
    private final List<ExportedToolInstallation> installations = new ArrayList<ExportedToolInstallation>();

    public ExportedToolDescriptor(String toolName, String symbol, Class<?> type) {
        this.toolName = toolName;
        this.symbol = symbol;
        this.type = type;
    }

    @Exported
    public String getToolName() {
        return this.toolName;
    }

    @Exported
    public String getSymbol() {
        return this.symbol;
    }

    @Exported
    public String getType() {
        return this.type.getName();
    }

    @Exported
    public ExportedToolInstallation[] getInstallations() {
        return this.installations.toArray(new ExportedToolInstallation[0]);
    }

    public void addInstallation(ExportedToolInstallation installation) {
        this.installations.add(installation);
    }

    @ExportedBean
    public static class ExportedToolInstallation {
        private final String name;
        private final Class<?> type;

        public ExportedToolInstallation(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        @Exported
        public String getName() {
            return this.name;
        }

        @Exported
        public String getType() {
            return this.type.getName();
        }
    }
}

