/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.pageable;

import com.google.common.collect.Iterators;
import io.jenkins.blueocean.rest.Utils;
import io.jenkins.blueocean.rest.pageable.Pageable;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Pageables {
    private static final Logger logger = LoggerFactory.getLogger(Pageables.class);

    private Pageables() {
    }

    public static <T> Pageable<T> empty() {
        return Pageables.wrap(Collections.emptyList());
    }

    public static <T> Iterator<T> slice(Iterator<T> base, int start, int limit) {
        int skipped = Utils.skip(base, start);
        if (skipped < start) {
            Iterators.emptyIterator();
        }
        return Iterators.limit(base, (int)limit);
    }

    public static <T> Pageable<T> wrap(final Iterable<T> base) {
        return new Pageable<T>(){

            @Override
            public Iterator<T> iterator(int start, int limit) {
                return Pageables.slice(this.iterator(), start, limit);
            }

            @Override
            public Iterator<T> iterator() {
                return base.iterator();
            }
        };
    }
}

