'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TruncatingLabel = exports.RenderStateValues = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _RenderStateValues;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

//--------------------------------------
//  Safety constants
//--------------------------------------

var MINLENGTH = 5; // Minimum size of cut-down text
var MAXLOOPS = 50; // Max no of iterations attempting to find the correct size text

//--------------------------------------
//  Flow types
//--------------------------------------

// Render lifecycle
var RS_MEASURE = 'measure'; // Mounted, text/props changed, measurement needed.
var RS_FLUID = 'fluid'; // Text too big, in the process of trimming it down
var RS_STABLE = 'stable'; // Done measuring, until props change

var RenderStateValues = exports.RenderStateValues = (_RenderStateValues = {}, _defineProperty(_RenderStateValues, RS_MEASURE, RS_MEASURE), _defineProperty(_RenderStateValues, RS_FLUID, RS_FLUID), _defineProperty(_RenderStateValues, RS_STABLE, RS_STABLE), _RenderStateValues);

// react.Component.props

/**
 * Multi-line label that will truncate with ellipses
 *
 * Use with a set width + height (or maxWidth / maxHeight) to get any use from it :D
 *
 * @deprecated Don't use this, the latest version exists in the ux-widgets repo alongside the updated PipelineGraph
 */
var TruncatingLabel = exports.TruncatingLabel = function (_Component) {
    _inherits(TruncatingLabel, _Component);

    function TruncatingLabel() {
        _classCallCheck(this, TruncatingLabel);

        return _possibleConstructorReturn(this, (TruncatingLabel.__proto__ || Object.getPrototypeOf(TruncatingLabel)).apply(this, arguments));
    }

    _createClass(TruncatingLabel, [{
        key: 'componentWillMount',
        // to avoid infinite iteration

        //--------------------------------------
        //  React Lifecycle
        //--------------------------------------

        // Length of the longest truncated text that fits
        // window.requestAnimationFrame handle

        //--------------------------------------
        //  Binary search state
        //--------------------------------------

        // Current innerText of element - includes possible ellipses
        value: function componentWillMount() {
            this.handleProps(this.props);
        } // Length of the shortest truncated text that does not fit
        // Last count used to truncate completeText
        // Internal rendering lifecycle state
        // Unabridged plain text content

        //--------------------------------------
        //  Component state / lifecycle
        //--------------------------------------

    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this.handleProps(nextProps);
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.invalidateSize();
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            this.invalidateSize();
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.checkSizeRequest) {
                cancelAnimationFrame(this.checkSizeRequest);
                this.checkSizeRequest = 0;
            }
        }

        //--------------------------------------
        //  Render
        //--------------------------------------

    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                _props$style = _props.style,
                style = _props$style === undefined ? {} : _props$style,
                _props$className = _props.className,
                className = _props$className === undefined ? '' : _props$className;


            var mergedStyle = _extends({
                overflow: 'hidden',
                wordWrap: 'break-word'
            }, style);

            if (this.renderState !== RS_STABLE) {
                mergedStyle.opacity = 0;
            }

            return _react2.default.createElement(
                'div',
                { style: mergedStyle, className: 'TruncatingLabel ' + className, title: this.innerText },
                this.innerText
            );
        }

        //--------------------------------------
        //  Internal Rendering Lifecycle
        //--------------------------------------

    }, {
        key: 'handleProps',
        value: function handleProps(props) {
            var _props$children = props.children,
                children = _props$children === undefined ? '' : _props$children;


            if (typeof children === 'string') {
                this.completeText = children;
            } else if (children === null || children === false) {
                this.completeText = ''; // Assume content has been boolean'd out
            } else {
                console.warn('TruncatingLabel - Label children must be string but is', typeof children === 'undefined' ? 'undefined' : _typeof(children), children);
                this.completeText = 'Contents must be string';
            }

            this.renderState = RS_MEASURE;
            this.innerText = this.completeText;
            this.loopCount = 0;
            this.longestGood = MINLENGTH;
            this.shortestBad = this.innerText.length;
        }
    }, {
        key: 'invalidateSize',
        value: function invalidateSize() {
            var _this2 = this;

            if (!this.checkSizeRequest) {
                this.checkSizeRequest = requestAnimationFrame(function () {
                    return _this2.checkSize();
                });
            }
        }
    }, {
        key: 'checkSize',
        value: function checkSize() {
            this.checkSizeRequest = 0;

            if (this.renderState === RS_STABLE) {
                return; // Nothing to check, no more checks to schedule
            }

            var thisElement = _reactDom2.default.findDOMNode(this);
            var scrollHeight = thisElement.scrollHeight,
                clientHeight = thisElement.clientHeight,
                scrollWidth = thisElement.scrollWidth,
                clientWidth = thisElement.clientWidth;


            var tooBig = scrollHeight > clientHeight || scrollWidth > clientWidth;

            if (this.renderState === RS_MEASURE) {
                // First measurement since mount / props changed

                if (tooBig) {
                    this.renderState = RS_FLUID;

                    // Set initial params for binary search of length
                    this.longestGood = MINLENGTH;
                    this.textCutoffLength = this.shortestBad = this.innerText.length;
                } else {
                    this.renderState = RS_STABLE;
                    this.forceUpdate(); // Re-render via react so it can update the alpha
                }
            }

            if (this.renderState === RS_FLUID) {
                this.loopCount++;

                var lastLength = this.textCutoffLength;

                var keepMeasuring = void 0;

                if (this.loopCount >= MAXLOOPS) {
                    // This really shouldn't happen!
                    console.error('TruncatingLabel - TOO MANY LOOPS');
                    keepMeasuring = false;
                } else if (lastLength <= MINLENGTH) {
                    keepMeasuring = false;
                } else if (Math.abs(this.shortestBad - this.longestGood) < 2) {
                    // We're done searching, hoorays!
                    keepMeasuring = false;
                } else {
                    // Update search space
                    if (tooBig) {
                        this.shortestBad = Math.min(this.shortestBad, lastLength);
                    } else {
                        this.longestGood = Math.max(this.longestGood, lastLength);
                    }

                    // Calculate the next length and update the text
                    this.textCutoffLength = Math.floor((this.longestGood + this.shortestBad) / 2);
                    this.innerText = this.completeText.substr(0, this.textCutoffLength) + '…';

                    // Bypass react's render loop during the "fluid" state for performance
                    thisElement.innerText = this.innerText;
                    keepMeasuring = true;
                }

                if (keepMeasuring) {
                    this.invalidateSize();
                } else {
                    this.renderState = RS_STABLE;
                    this.forceUpdate(); // Re-render via react so it knows about updated alpha and final content
                }
            }
        }
    }]);

    return TruncatingLabel;
}(_react.Component);

TruncatingLabel.propTypes = {
    children: _react.PropTypes.string,
    style: _react.PropTypes.object,
    className: _react.PropTypes.string
};
//# sourceMappingURL=TruncatingLabel.js.map
