'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RadioButtonGroup = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Utils = require('../../Utils');

var _Utils2 = _interopRequireDefault(_Utils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Renders a group of radio buttons for the provided 'options'
 * By default the radio buttons are arranged vertically
 *
 * Props:
 *      className: additional class name(s) to add to root element.
 *          Use 'is-layout-horizontal' to change layout direction.
 *      options: an array of options to map to radio buttons. Can be strings or objects.
 *      defaultOption: option to select/check by default if no selection was already made by user.
 *      labelField: if using objects for options, name of property to use for label.
 *      labelFunction: a function that receives the option and returns a string for label.
 *      onChange: handler func calls when user changes selection, receiving 'option' as only arg.
 */
var RadioButtonGroup = exports.RadioButtonGroup = function (_React$Component) {
    _inherits(RadioButtonGroup, _React$Component);

    function RadioButtonGroup(props) {
        _classCallCheck(this, RadioButtonGroup);

        var _this = _possibleConstructorReturn(this, (RadioButtonGroup.__proto__ || Object.getPrototypeOf(RadioButtonGroup)).call(this, props));

        _this.state = {
            selectedOption: null
        };

        _this.groupId = function () {
            return _Utils2.default.randomId('RadioButtonGroup');
        };
        return _this;
    }

    _createClass(RadioButtonGroup, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this._defaultSelection(this.props);
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this._defaultSelection(nextProps);
        }
    }, {
        key: '_defaultSelection',
        value: function _defaultSelection(props) {
            if (!this.state.selectedOption && props.defaultOption) {
                this.setState({
                    selectedOption: props.defaultOption
                });
            }
        }
    }, {
        key: '_onChange',
        value: function _onChange(option) {
            this.setState({
                selectedOption: option
            });

            if (this.props.onChange) {
                this.props.onChange(option);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var groupId = this.groupId();

            return _react2.default.createElement(
                'div',
                { className: 'RadioButtonGroup ' + this.props.className },
                this.props.options.map(function (option, index) {
                    var checked = option === _this2.state.selectedOption;

                    var labelValue = '';

                    if (_this2.props.labelField) {
                        labelValue = option[_this2.props.labelField];
                    } else if (_this2.props.labelFunction) {
                        labelValue = _this2.props.labelFunction(option);
                    } else {
                        labelValue = option.toString();
                    }

                    return _react2.default.createElement(
                        'label',
                        { key: index, className: 'RadioButtonGroup-item' },
                        _react2.default.createElement('input', {
                            className: 'RadioButtonGroup-button',
                            name: groupId,
                            type: 'radio',
                            checked: checked,
                            disabled: _this2.props.disabled,
                            onChange: function onChange() {
                                return _this2._onChange(option);
                            }
                        }),
                        _react2.default.createElement(Indicator, null),
                        _react2.default.createElement(
                            'span',
                            { className: 'RadioButtonGroup-text' },
                            labelValue
                        )
                    );
                })
            );
        }
    }, {
        key: 'selectedOption',
        get: function get() {
            return this.state.selectedOption;
        }
    }]);

    return RadioButtonGroup;
}(_react2.default.Component);

RadioButtonGroup.propTypes = {
    className: _react.PropTypes.string,
    options: _react.PropTypes.array,
    defaultOption: _react.PropTypes.any,
    labelField: _react.PropTypes.string,
    labelFunction: _react.PropTypes.func,
    disabled: _react.PropTypes.bool,
    onChange: _react.PropTypes.func
};

RadioButtonGroup.defaultProps = {
    className: ''
};

function Indicator() {
    return _react2.default.createElement(
        'div',
        { className: 'RadioButtonGroup-indicator' },
        _react2.default.createElement(
            'svg',
            { xmlns: 'http://www.w3.org/2000/svg', viewBox: '0 0 20 20', width: '100%', height: '100%', className: 'svg-shape', focusable: 'false' },
            _react2.default.createElement(
                'g',
                null,
                _react2.default.createElement('circle', { className: 'outer-circle', cx: '10', cy: '10', r: '9.5', stroke: 'black', strokeWidth: '1', fill: 'none', shapeRendering: 'geometricPrecision' }),
                _react2.default.createElement('circle', { className: 'inner-circle', cx: '10', cy: '10', r: '3', fill: 'white', shapeRendering: 'geometricPrecision' })
            )
        ),
        _react2.default.createElement('div', { className: 'RadioButtonGroup-focus' })
    );
}
//# sourceMappingURL=RadioButtonGroup.js.map
