'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _WithContext = require('./WithContext');

var _WithContext2 = _interopRequireDefault(_WithContext);

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('Header', module).add('Basic', basic).add('StatusColor', statusColors).add('Split', split);

var Width = function Width() {

    var outer = {
        display: 'block',
        marginTop: '5em',
        marginLeft: 'auto',
        marginRight: 'auto',
        width: '100%',
        maxWidth: '1200px',
        padding: '0 15px',
        background: 'red',
        color: 'white'
    };

    var inner = {
        background: 'rgba(0,0,0,0.3)',
        textAlign: 'center',
        padding: '1em'
    };

    return _react2.default.createElement(
        'div',
        { style: outer },
        _react2.default.createElement(
            'div',
            { style: inner },
            '1200 total'
        )
    );
};

/**
 * We'll show a single-parent and split header side-by side here, to make sure they look the same. We want to be able
 * to split the normal content page style header into two, because in BO we have a "site header" in blueocean-web, and
 * we need pages located in plugins to be able to control their own "page header" with the HeaderDetails
 */
function split() {

    var containerStyle = {
        display: "flex"
    };

    var colStyle = {
        width: "50%"
    };

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            'div',
            { style: containerStyle },
            _react2.default.createElement(
                'div',
                { style: colStyle },
                _react2.default.createElement(
                    _components.BasicHeader,
                    null,
                    _react2.default.createElement(
                        _components.TopNav,
                        { style: { justifyContent: "center" } },
                        'The left and right halves of this...'
                    ),
                    _react2.default.createElement(
                        _components.HeaderDetails,
                        { style: { justifyContent: "center" } },
                        '... should appear the same.'
                    )
                )
            ),
            _react2.default.createElement(
                'div',
                { style: colStyle },
                _react2.default.createElement(
                    _components.BasicHeader,
                    null,
                    _react2.default.createElement(
                        _components.TopNav,
                        { style: { justifyContent: "center" } },
                        'We need to be able to split the basic header in two...'
                    )
                ),
                _react2.default.createElement(
                    _components.BasicHeader,
                    null,
                    _react2.default.createElement(
                        _components.HeaderDetails,
                        { style: { justifyContent: "center" } },
                        '... because it lives in two modules in BlueOcean'
                    )
                )
            )
        ),
        _react2.default.createElement(Width, null)
    );
}

var Example = function Example(props) {
    return _react2.default.createElement(
        _components.BasicHeader,
        props,
        _react2.default.createElement(
            _components.TopNav,
            { style: { justifyContent: "center" } },
            'This is an example with statusColor ',
            props.statusColor || "(none)",
            '.'
        ),
        _react2.default.createElement(
            _components.HeaderDetails,
            { style: { justifyContent: "center" } },
            'This is an example with statusColor ',
            props.statusColor || "(none)",
            '.'
        )
    );
};

function basic() {

    var tabLinkContext = {
        router: {
            isActive: function isActive(org) {
                return org === '/c';
            },
            createHref: function createHref() {
                return "#";
            }
        }
    };

    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
            _components.BasicHeader,
            null,
            _react2.default.createElement(
                _components.TopNav,
                null,
                _react2.default.createElement(
                    'div',
                    { className: 'Header-title' },
                    _react2.default.createElement(
                        'h1',
                        null,
                        'Site navigation, user profile, login / logout'
                    )
                ),
                _react2.default.createElement(
                    'nav',
                    null,
                    _react2.default.createElement(
                        'a',
                        { href: '#', className: 'selected' },
                        'Anchor'
                    ),
                    _react2.default.createElement(
                        'a',
                        { href: '#' },
                        'Bravo'
                    ),
                    _react2.default.createElement(
                        'a',
                        { href: '#' },
                        'Charlie'
                    ),
                    _react2.default.createElement(
                        'a',
                        { href: '#' },
                        'Xyzzy LTjg'
                    )
                )
            ),
            _react2.default.createElement(
                _components.HeaderDetails,
                null,
                _react2.default.createElement(
                    'div',
                    { className: 'u-flex-grow', style: { justifyContent: "center" } },
                    'This area is for sub-nav, detailed information, etc.'
                ),
                _react2.default.createElement(
                    _components.PageTabs,
                    null,
                    _react2.default.createElement(
                        _WithContext2.default,
                        { context: tabLinkContext },
                        _react2.default.createElement(
                            _components.TabLink,
                            { to: '/a' },
                            'Ainsley'
                        )
                    ),
                    _react2.default.createElement(
                        _WithContext2.default,
                        { context: tabLinkContext },
                        _react2.default.createElement(
                            _components.TabLink,
                            { to: '/b' },
                            'Bill'
                        )
                    ),
                    _react2.default.createElement(
                        _WithContext2.default,
                        { context: tabLinkContext },
                        _react2.default.createElement(
                            _components.TabLink,
                            { to: '/c' },
                            'Ching He'
                        )
                    ),
                    _react2.default.createElement(
                        'a',
                        { href: '#' },
                        'Delia'
                    )
                )
            )
        ),
        _react2.default.createElement(Width, null)
    );
}

function statusColors() {
    return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(Example, null),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'success' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'failure' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'running' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'queued' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'unstable' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'aborted' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'not_built' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'paused' }),
        _react2.default.createElement(
            'p',
            null,
            '\xA0'
        ),
        _react2.default.createElement(Example, { statusColor: 'unknown' })
    );
}
//# sourceMappingURL=HeaderStories.js.map
