'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var styleId = 'storybook-css';

/**
 * Creates a style rule.
 * Usage:
 *      createCssRule(
 *          '.red-bold',
 *          'color: #f00; font-weight: bold'
 *      )
 * @param selector
 * @param rules
 */
function createCssRule(selector) {
    var styles = document.getElementById(styleId);

    if (!styles) {
        styles = document.createElement('style');
        styles.type = 'text/css';
        styles.id = styleId;
        document.getElementsByTagName('head')[0].appendChild(styles);
    }

    var sheet = styles.sheet;

    // add each rule via 'insertRule' if that rule doesn't already exist
    // (needed due to storybook / webpack hot reloading)

    for (var _len = arguments.length, rules = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        rules[_key - 1] = arguments[_key];
    }

    for (var i = 0; i < rules.length; i++) {
        var rule = rules[i];
        var cssText = selector + ' { ' + rule + '; }';
        var found = false;

        for (var j = 0; j < sheet.cssRules.length; j++) {
            var existingRule = sheet.cssRules[j];
            if (cssText === existingRule.cssText) {
                found = true;
                break;
            }
        }

        if (!found) {
            // insertRule won't allow semicolons
            sheet.insertRule(cssText.replace(';', ''), 0);
        }
    }
}

exports.default = {
    createCssRule: createCssRule
};
//# sourceMappingURL=Utils.js.map
