/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.secrets;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import hudson.Extension;
import io.jenkins.plugins.casc.SecretSource;
import io.jenkins.plugins.casc.impl.secrets.vault.VaultAuthenticator;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Extension
public class VaultSecretSource
extends SecretSource {
    private static final Logger LOGGER = Logger.getLogger(VaultSecretSource.class.getName());
    private static final String CASC_VAULT_FILE = "CASC_VAULT_FILE";
    private static final String CASC_VAULT_PW = "CASC_VAULT_PW";
    private static final String CASC_VAULT_USER = "CASC_VAULT_USER";
    private static final String CASC_VAULT_URL = "CASC_VAULT_URL";
    private static final String CASC_VAULT_MOUNT = "CASC_VAULT_MOUNT";
    private static final String CASC_VAULT_TOKEN = "CASC_VAULT_TOKEN";
    private static final String CASC_VAULT_APPROLE = "CASC_VAULT_APPROLE";
    private static final String CASC_VAULT_APPROLE_SECRET = "CASC_VAULT_APPROLE_SECRET";
    private static final String CASC_VAULT_NAMESPACE = "CASC_VAULT_NAMESPACE";
    private static final String CASC_VAULT_ENGINE_VERSION = "CASC_VAULT_ENGINE_VERSION";
    private static final String CASC_VAULT_PATHS = "CASC_VAULT_PATHS";
    private static final String CASC_VAULT_PATH = "CASC_VAULT_PATH";
    private static final String DEFAULT_ENGINE_VERSION = "2";
    private static final String DEFAULT_USER_BACKEND = "userpass";
    private Map<String, String> secrets = new HashMap<String, String>();
    private Vault vault;
    private VaultConfig vaultConfig;
    private VaultAuthenticator vaultAuthenticator;
    private String[] vaultPaths;
    private Properties prop;

    private void configureVault() {
        this.prop = new Properties();
        Optional<String> vaultFile = Optional.ofNullable(System.getenv(CASC_VAULT_FILE));
        vaultFile.ifPresent(this::readPropertiesFromVaultFile);
        Optional<String> vaultEngineVersionOpt = this.getVariable(CASC_VAULT_ENGINE_VERSION);
        Optional<String> vaultUrl = this.getVariable(CASC_VAULT_URL);
        Optional<String> vaultNamespace = this.getVariable(CASC_VAULT_NAMESPACE);
        Optional vaultPaths = this.getCommaSeparatedVariables(CASC_VAULT_PATHS).map(Optional::of).orElseGet(() -> this.getCommaSeparatedVariables(CASC_VAULT_PATH));
        if (!vaultUrl.isPresent() || !vaultPaths.isPresent()) {
            return;
        }
        String vaultEngineVersion = vaultEngineVersionOpt.orElse(DEFAULT_ENGINE_VERSION);
        this.vaultPaths = (String[])vaultPaths.get();
        this.determineAuthenticator();
        this.vaultConfig = new VaultConfig().address(vaultUrl.get());
        try {
            LOGGER.log(Level.FINE, "Attempting to connect to Vault: {0}", vaultUrl);
            if (vaultNamespace.isPresent()) {
                this.vaultConfig.nameSpace(vaultNamespace.get());
                LOGGER.log(Level.FINE, "Using namespace with Vault: {0}", vaultNamespace);
            }
            this.vaultConfig.engineVersion(Integer.valueOf(Integer.parseInt(vaultEngineVersion)));
            LOGGER.log(Level.FINE, "Using engine version: {0}", vaultEngineVersion);
        }
        catch (VaultException e) {
            LOGGER.log(Level.WARNING, "Could not configure vault connection", e);
        }
        try {
            this.vaultConfig.build();
        }
        catch (VaultException e) {
            LOGGER.log(Level.WARNING, "Could not configure vault client", e);
        }
        this.vault = new Vault(this.vaultConfig);
    }

    private void determineAuthenticator() {
        Optional<String> vaultPw = this.getVariable(CASC_VAULT_PW);
        Optional<String> vaultUser = this.getVariable(CASC_VAULT_USER);
        Optional<String> vaultToken = this.getVariable(CASC_VAULT_TOKEN);
        Optional<String> vaultAppRole = this.getVariable(CASC_VAULT_APPROLE);
        Optional<String> vaultAppRoleSecret = this.getVariable(CASC_VAULT_APPROLE_SECRET);
        vaultToken.ifPresent(this::token);
        VaultSecretSource.allPresent(vaultUser, vaultPw, this::userPass);
        VaultSecretSource.allPresent(vaultAppRole, vaultAppRoleSecret, this::approle);
        if (this.vaultAuthenticator == null) {
            LOGGER.log(Level.WARNING, "Could not determine vault authentication method. Not able to read secrets from vault.");
        }
    }

    private void setAuthenticator(VaultAuthenticator vaultAuthenticator) {
        if (vaultAuthenticator != null && !vaultAuthenticator.equals(this.vaultAuthenticator)) {
            this.vaultAuthenticator = vaultAuthenticator;
        }
    }

    public static <T, U> void allPresent(Optional<T> o1, Optional<U> o2, BiConsumer<T, U> consumer) {
        o1.ifPresent(t -> o2.ifPresent(u -> consumer.accept(t, u)));
    }

    private void token(String token) {
        this.setAuthenticator(VaultAuthenticator.of(token));
    }

    private void userPass(String user, String pass) {
        Optional<String> mount = this.getVariable(CASC_VAULT_MOUNT);
        this.setAuthenticator(VaultAuthenticator.of(user, pass, mount.orElse(DEFAULT_USER_BACKEND)));
    }

    private void approle(String approle, String approleSecret) {
        this.setAuthenticator(VaultAuthenticator.of(approle, approleSecret));
    }

    private void readSecretsFromVault() {
        Optional<String[]> vaultPathsOpt = Optional.ofNullable(this.vaultPaths);
        if (vaultPathsOpt.isPresent()) {
            try {
                this.secrets = new HashMap<String, String>();
                for (String vaultPath : vaultPathsOpt.get()) {
                    Map nextSecrets = this.vault.logical().read(vaultPath).getData();
                    for (String key : nextSecrets.keySet()) {
                        if (!this.secrets.containsKey(key)) continue;
                        LOGGER.log(Level.WARNING, "Key {0} exists in multiple vault paths.", key);
                    }
                    this.secrets.putAll(nextSecrets);
                }
            }
            catch (VaultException e) {
                LOGGER.log(Level.WARNING, "Unable to fetch secret from Vault", e);
            }
        }
    }

    private void readPropertiesFromVaultFile(String vaultFile) {
        try (FileInputStream input = new FileInputStream(vaultFile);){
            this.prop.load(input);
            if (this.prop.isEmpty()) {
                LOGGER.log(Level.WARNING, "Vault secret file is empty");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Failed to load Vault secrets from file", ex);
        }
    }

    @Override
    public Optional<String> reveal(String secret) {
        if (StringUtils.isBlank((String)secret)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.secrets.get(secret));
    }

    public Map<String, String> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
    }

    private Optional<String> getVariable(String key) {
        return Optional.ofNullable(this.prop.getProperty(key, System.getenv(key)));
    }

    private Optional<String[]> getCommaSeparatedVariables(String key) {
        Optional<String[]> strings = this.getVariable(key).map(str -> str.split(","));
        if (key.equals(CASC_VAULT_PATH) && strings.isPresent()) {
            LOGGER.log(Level.WARNING, "[Deprecation Warning] CASC_VAULT_PATH is deprecated. Please use CASC_VAULT_PATHS instead.");
        }
        return strings;
    }

    @Override
    public void init() {
        this.configureVault();
        if (this.vaultAuthenticator != null) {
            try {
                this.vaultAuthenticator.authenticate(this.vault, this.vaultConfig);
            }
            catch (VaultException e) {
                LOGGER.log(Level.WARNING, "Could not authenticate with vault client", e);
            }
            this.readSecretsFromVault();
        }
    }
}

