/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import com.google.common.base.Defaults;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.util.Secret;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.attributes.DescribableAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class DataBoundConfigurator<T>
extends BaseConfigurator<T> {
    private static final Logger LOGGER = Logger.getLogger(DataBoundConfigurator.class.getName());
    private final Class<T> target;

    public DataBoundConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @CheckForNull
    public static Constructor getDataBoundConstructor(@NonNull Class type) {
        for (Constructor<?> c : type.getConstructors()) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            return c;
        }
        return null;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    protected T instance(Mapping config, ConfigurationContext context) throws ConfiguratorException {
        Constructor dataBoundConstructor = this.getDataBoundConstructor();
        return this.tryConstructor(dataBoundConstructor, config, context);
    }

    @Override
    @NonNull
    public T configure(CNode c, ConfigurationContext context) throws ConfiguratorException {
        Object object = super.configure(c, context);
        for (Method method : this.target.getMethods()) {
            if (method.getParameterCount() != 0 || method.getAnnotation(PostConstruct.class) == null) continue;
            try {
                method.invoke(object, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfiguratorException(this, "Failed to invoke configurator method " + method, e);
            }
        }
        return object;
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return super.configure(config, context);
    }

    private T tryConstructor(Constructor<T> constructor, Mapping config, ConfigurationContext context) throws ConfiguratorException {
        T object;
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames(constructor);
        Object[] args = new Object[names.length];
        if (parameters.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                CNode value = (CNode)config.get(names[i]);
                Class<?> t = parameters[i].getType();
                Class<T> clazz = constructor.getDeclaringClass();
                if (value == null && (parameters[i].isAnnotationPresent(Nonnull.class) || constructor.isAnnotationPresent(ParametersAreNonnullByDefault.class) || clazz.isAnnotationPresent(ParametersAreNonnullByDefault.class) || clazz.getPackage().isAnnotationPresent(ParametersAreNonnullByDefault.class) && !parameters[i].isAnnotationPresent(CheckForNull.class))) {
                    if (Set.class.isAssignableFrom(t)) {
                        LOGGER.log(Level.FINER, "The parameter to be set is @Nonnull but is not present; setting equal to empty set.");
                        args[i] = Collections.emptySet();
                        continue;
                    }
                    if (List.class.isAssignableFrom(t)) {
                        LOGGER.log(Level.FINER, "The parameter to be set is @Nonnull but is not present; setting equal to empty list.");
                        args[i] = Collections.emptyList();
                        continue;
                    }
                    throw new ConfiguratorException(names[i] + " is required to configure " + this.target);
                }
                if (value != null) {
                    Type pt;
                    if (Collection.class.isAssignableFrom(t)) {
                        pt = parameters[i].getParameterizedType();
                        Configurator lookup = context.lookupOrFail(pt);
                        AbstractCollection collection = Set.class.isAssignableFrom(t) ? new HashSet() : new ArrayList();
                        for (CNode o : value.asSequence()) {
                            collection.add(lookup.configure(o, context));
                        }
                        args[i] = collection;
                    } else {
                        pt = parameters[i].getParameterizedType();
                        Class<?> k = pt != null ? pt : t;
                        Configurator configurator = context.lookupOrFail(k);
                        args[i] = configurator.configure(value, context);
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Setting {0}.{1} = {2}", new Object[]{this.target, names[i], t == Secret.class || Attribute.calculateIfSecret(this.target, names[i]) ? "****" : value});
                    continue;
                }
                if (!t.isPrimitive()) continue;
                args[i] = Defaults.defaultValue(t);
            }
        }
        try {
            object = constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            ArrayList<String> argumentTypes = new ArrayList<String>(args.length);
            for (Object arg : args) {
                argumentTypes.add(arg != null ? arg.getClass().getName() : "null");
            }
            ArrayList<String> parameterTypes = new ArrayList<String>(parameters.length);
            for (Parameter parameter : parameters) {
                parameterTypes.add(parameter.getParameterizedType().getTypeName());
            }
            ArrayList<String> expectedParamList = new ArrayList<String>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                expectedParamList.add(names[i] + " " + (String)parameterTypes.get(i));
            }
            throw new ConfiguratorException(this, "Failed to construct instance of " + this.target + ".\n Constructor: " + constructor.toString() + ".\n Arguments: " + argumentTypes + ".\n Expected Parameters: " + String.join((CharSequence)", ", expectedParamList), ex);
        }
        for (String name : names) {
            config.remove(name);
        }
        return object;
    }

    @Override
    @NonNull
    public String getName() {
        Descriptor d = this.getDescriptor();
        return DescribableAttribute.getPreferredSymbol(d, this.getImplementedAPI(), this.getTarget());
    }

    private Descriptor getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getTarget());
    }

    @Override
    @NonNull
    public Class getImplementedAPI() {
        Descriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            Type superclass;
            Class<?> c = descriptor.getClass();
            do {
                superclass = c.getGenericSuperclass();
            } while ((c = c.getSuperclass()) != Descriptor.class);
            if (superclass instanceof ParameterizedType) {
                ParameterizedType genericSuperclass = (ParameterizedType)superclass;
                Type type = genericSuperclass.getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                if (type instanceof Class) {
                    return (Class)type;
                }
            }
        }
        return super.getImplementedAPI();
    }

    @Override
    @NonNull
    public Set<Attribute<T, ?>> describe() {
        Set attributes = super.describe();
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor != null) {
            Parameter[] parameters = constructor.getParameters();
            String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                Attribute a = this.createAttribute(names[i], BaseConfigurator.TypePair.of(p));
                if (a == null) continue;
                attributes.add(a);
            }
        }
        return attributes;
    }

    @Override
    @CheckForNull
    public CNode describe(T instance, ConfigurationContext context) throws Exception {
        Constructor constructor = this.getDataBoundConstructor();
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
        Attribute[] attributes = new Attribute[parameters.length];
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            Attribute a = this.createAttribute(names[i], BaseConfigurator.TypePair.of(p));
            if (a == null) continue;
            Object value = a.getValue(instance);
            if (value != null) {
                Object converted = Stapler.CONVERT_UTILS.convert(value, a.getType());
                args[i] = converted instanceof Collection || p.getType().isArray() || !a.isMultiple() ? converted : (Set.class.isAssignableFrom(p.getType()) ? Collections.singleton(converted) : Collections.singletonList(converted));
            }
            if (args[i] == null && p.getType().isPrimitive()) {
                args[i] = Defaults.defaultValue(p.getType());
            }
            attributes[i] = a;
        }
        Object ref = constructor.newInstance(args);
        Mapping mapping = this.compare(instance, ref, context);
        for (int i = 0; i < parameters.length; ++i) {
            if (args[i] == null) continue;
            mapping.put(names[i], attributes[i].describe(instance, context));
        }
        return mapping;
    }

    private Constructor getDataBoundConstructor() throws ConfiguratorException {
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor == null) {
            throw new ConfiguratorException(this.target.getName() + " is missing a @DataBoundConstructor");
        }
        return constructor;
    }

    @Override
    public String getDisplayName() {
        Descriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getDisplayName() : this.getName();
    }
}

