/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Secret;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.SecretSourceResolver;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Scalar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Restricted(value={NoExternalUse.class})
public class PrimitiveConfigurator
implements Configurator {
    private final Class target;

    public PrimitiveConfigurator(Class clazz) {
        this.target = clazz;
    }

    public Class getTarget() {
        return this.target;
    }

    @NonNull
    public Set<Attribute> describe() {
        return Collections.emptySet();
    }

    @NonNull
    public Object configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return Stapler.lookupConverter((Class)this.target).convert(this.target, (Object)SecretSourceResolver.resolve(context, config.asScalar().toString()));
    }

    public Object check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return this.configure(config, context);
    }

    @CheckForNull
    public CNode describe(Object instance, ConfigurationContext context) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof Number) {
            return new Scalar((Number)instance);
        }
        if (instance instanceof Boolean) {
            return new Scalar((Boolean)instance);
        }
        if (instance instanceof Secret) {
            return new Scalar(((Secret)instance).getEncryptedValue()).encrypted(true);
        }
        if (this.target.isEnum()) {
            return new Scalar((Enum)instance);
        }
        return new Scalar(SecretSourceResolver.encode(String.valueOf(instance)));
    }

    @NonNull
    public List<Configurator> getConfigurators(ConfigurationContext context) {
        return Collections.emptyList();
    }
}

