/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.util;

import java.lang.reflect.Field;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ExtraFieldUtils
extends FieldUtils {
    @CheckForNull
    public static Field getFieldNoForce(Class cls, String fieldName) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        for (Class acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException field) {
                continue;
            }
        }
        Field match = null;
        Iterator intf = ClassUtils.getAllInterfaces((Class)cls).iterator();
        while (intf.hasNext()) {
            try {
                Field test = ((Class)intf.next()).getField(fieldName);
                if (match != null) {
                    throw new IllegalArgumentException("Reference to field " + fieldName + " is ambiguous relative to " + cls + "; a matching field exists on two or more implemented interfaces.");
                }
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }
}

