/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.yaml;

import io.jenkins.plugins.casc.yaml.YamlReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.servlet.http.HttpServletRequest;

public class YamlSource<T>
implements AutoCloseable {
    public static final YamlReader<String> READ_FROM_URL = config -> {
        URL url = URI.create(config).toURL();
        return new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
    };
    public static final YamlReader<Path> READ_FROM_PATH = Files::newBufferedReader;
    public static final YamlReader<InputStream> READ_FROM_INPUTSTREAM = in -> new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
    public static final YamlReader<HttpServletRequest> READ_FROM_REQUEST = req -> new InputStreamReader((InputStream)req.getInputStream(), StandardCharsets.UTF_8);
    public final T source;
    public final YamlReader<T> reader;

    public YamlSource(T source, YamlReader<T> reader) {
        this.source = source;
        this.reader = reader;
    }

    public static YamlSource<InputStream> of(InputStream in) {
        return new YamlSource<InputStream>(in, READ_FROM_INPUTSTREAM);
    }

    public static YamlSource<String> of(URL url) {
        return new YamlSource<String>(url.toExternalForm(), READ_FROM_URL);
    }

    public static YamlSource<String> of(String url) {
        return new YamlSource<String>(url, READ_FROM_URL);
    }

    public static YamlSource<HttpServletRequest> of(HttpServletRequest req) {
        return new YamlSource<HttpServletRequest>(req, READ_FROM_REQUEST);
    }

    public static YamlSource<Path> of(Path path) {
        return new YamlSource<Path>(path, READ_FROM_PATH);
    }

    public Reader read() throws IOException {
        return this.reader.open(this.source);
    }

    public String source() {
        return this.source.toString();
    }

    public String toString() {
        return "YamlSource: " + this.source;
    }

    @Override
    public void close() throws IOException {
        if (this.reader instanceof BufferedReader) {
            ((BufferedReader)((Object)this.reader)).close();
        } else if (this.reader instanceof InputStreamReader) {
            ((InputStreamReader)((Object)this.reader)).close();
        }
    }
}

