// CHECKSTYLE:OFF

package com.atlassian.bitbucket.jenkins.internal.deployments;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.STAGING}: {@code
     * Staging}.
     * 
     * @return
     *     {@code Staging}
     */
    public static String BitbucketDeploymentEnvironmentType_STAGING() {
        return holder.format("BitbucketDeploymentEnvironmentType.STAGING");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.STAGING}: {@code
     * Staging}.
     * 
     * @return
     *     {@code Staging}
     */
    public static Localizable _BitbucketDeploymentEnvironmentType_STAGING() {
        return new Localizable(holder, "BitbucketDeploymentEnvironmentType.STAGING");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.UriAbsolute}: {@code The
     * deployment URI must be absolute}.
     * 
     * @return
     *     {@code The deployment URI must be absolute}
     */
    public static String DeploymentStepDescriptorHelper_UriAbsolute() {
        return holder.format("DeploymentStepDescriptorHelper.UriAbsolute");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.UriAbsolute}: {@code The
     * deployment URI must be absolute}.
     * 
     * @return
     *     {@code The deployment URI must be absolute}
     */
    public static Localizable _DeploymentStepDescriptorHelper_UriAbsolute() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.UriAbsolute");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentTypeInvalid}:
     * {@code The environment type should be one of DEVELOPMENT, PRODUCTION,
     * STAGING, TESTING}.
     * 
     * @return
     *     {@code The environment type should be one of DEVELOPMENT, PRODUCTION,
     *     STAGING, TESTING}
     */
    public static String DeploymentStepDescriptorHelper_EnvironmentTypeInvalid() {
        return holder.format("DeploymentStepDescriptorHelper.EnvironmentTypeInvalid");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentTypeInvalid}:
     * {@code The environment type should be one of DEVELOPMENT, PRODUCTION,
     * STAGING, TESTING}.
     * 
     * @return
     *     {@code The environment type should be one of DEVELOPMENT, PRODUCTION,
     *     STAGING, TESTING}
     */
    public static Localizable _DeploymentStepDescriptorHelper_EnvironmentTypeInvalid() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.EnvironmentTypeInvalid");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentUrlInvalid}:
     * {@code The environment URL must be a valid URL}.
     * 
     * @return
     *     {@code The environment URL must be a valid URL}
     */
    public static String DeploymentStepDescriptorHelper_EnvironmentUrlInvalid() {
        return holder.format("DeploymentStepDescriptorHelper.EnvironmentUrlInvalid");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentUrlInvalid}:
     * {@code The environment URL must be a valid URL}.
     * 
     * @return
     *     {@code The environment URL must be a valid URL}
     */
    public static Localizable _DeploymentStepDescriptorHelper_EnvironmentUrlInvalid() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.EnvironmentUrlInvalid");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.PRODUCTION}: {@code
     * Production}.
     * 
     * @return
     *     {@code Production}
     */
    public static String BitbucketDeploymentEnvironmentType_PRODUCTION() {
        return holder.format("BitbucketDeploymentEnvironmentType.PRODUCTION");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.PRODUCTION}: {@code
     * Production}.
     * 
     * @return
     *     {@code Production}
     */
    public static Localizable _BitbucketDeploymentEnvironmentType_PRODUCTION() {
        return new Localizable(holder, "BitbucketDeploymentEnvironmentType.PRODUCTION");
    }

    /**
     * Key {@code DeploymentNotifier.DisplayName}: {@code Notify Bitbucket
     * Server of deployment}.
     * 
     * @return
     *     {@code Notify Bitbucket Server of deployment}
     */
    public static String DeploymentNotifier_DisplayName() {
        return holder.format("DeploymentNotifier.DisplayName");
    }

    /**
     * Key {@code DeploymentNotifier.DisplayName}: {@code Notify Bitbucket
     * Server of deployment}.
     * 
     * @return
     *     {@code Notify Bitbucket Server of deployment}
     */
    public static Localizable _DeploymentNotifier_DisplayName() {
        return new Localizable(holder, "DeploymentNotifier.DisplayName");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.DEVELOPMENT}: {@code
     * Development}.
     * 
     * @return
     *     {@code Development}
     */
    public static String BitbucketDeploymentEnvironmentType_DEVELOPMENT() {
        return holder.format("BitbucketDeploymentEnvironmentType.DEVELOPMENT");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.DEVELOPMENT}: {@code
     * Development}.
     * 
     * @return
     *     {@code Development}
     */
    public static Localizable _BitbucketDeploymentEnvironmentType_DEVELOPMENT() {
        return new Localizable(holder, "BitbucketDeploymentEnvironmentType.DEVELOPMENT");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentNameRequired}:
     * {@code The environment name is required}.
     * 
     * @return
     *     {@code The environment name is required}
     */
    public static String DeploymentStepDescriptorHelper_EnvironmentNameRequired() {
        return holder.format("DeploymentStepDescriptorHelper.EnvironmentNameRequired");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentNameRequired}:
     * {@code The environment name is required}.
     * 
     * @return
     *     {@code The environment name is required}
     */
    public static Localizable _DeploymentStepDescriptorHelper_EnvironmentNameRequired() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.EnvironmentNameRequired");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.UriTooLong}: {@code The
     * deployment URI must be shorter than 1024 characters}.
     * 
     * @return
     *     {@code The deployment URI must be shorter than 1024 characters}
     */
    public static String DeploymentStepDescriptorHelper_UriTooLong() {
        return holder.format("DeploymentStepDescriptorHelper.UriTooLong");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.UriTooLong}: {@code The
     * deployment URI must be shorter than 1024 characters}.
     * 
     * @return
     *     {@code The deployment URI must be shorter than 1024 characters}
     */
    public static Localizable _DeploymentStepDescriptorHelper_UriTooLong() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.UriTooLong");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.TESTING}: {@code
     * Testing}.
     * 
     * @return
     *     {@code Testing}
     */
    public static String BitbucketDeploymentEnvironmentType_TESTING() {
        return holder.format("BitbucketDeploymentEnvironmentType.TESTING");
    }

    /**
     * Key {@code BitbucketDeploymentEnvironmentType.TESTING}: {@code
     * Testing}.
     * 
     * @return
     *     {@code Testing}
     */
    public static Localizable _BitbucketDeploymentEnvironmentType_TESTING() {
        return new Localizable(holder, "BitbucketDeploymentEnvironmentType.TESTING");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentNameTooLong}:
     * {@code The environment name must be shorter than 255 characters}.
     * 
     * @return
     *     {@code The environment name must be shorter than 255 characters}
     */
    public static String DeploymentStepDescriptorHelper_EnvironmentNameTooLong() {
        return holder.format("DeploymentStepDescriptorHelper.EnvironmentNameTooLong");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EnvironmentNameTooLong}:
     * {@code The environment name must be shorter than 255 characters}.
     * 
     * @return
     *     {@code The environment name must be shorter than 255 characters}
     */
    public static Localizable _DeploymentStepDescriptorHelper_EnvironmentNameTooLong() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.EnvironmentNameTooLong");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.KeyTooLong}: {@code The
     * environment key must be shorter than 255 characters}.
     * 
     * @return
     *     {@code The environment key must be shorter than 255 characters}
     */
    public static String DeploymentStepDescriptorHelper_KeyTooLong() {
        return holder.format("DeploymentStepDescriptorHelper.KeyTooLong");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.KeyTooLong}: {@code The
     * environment key must be shorter than 255 characters}.
     * 
     * @return
     *     {@code The environment key must be shorter than 255 characters}
     */
    public static Localizable _DeploymentStepDescriptorHelper_KeyTooLong() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.KeyTooLong");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EmptySelection}: {@code -
     * none -}.
     * 
     * @return
     *     {@code - none -}
     */
    public static String DeploymentStepDescriptorHelper_EmptySelection() {
        return holder.format("DeploymentStepDescriptorHelper.EmptySelection");
    }

    /**
     * Key {@code DeploymentStepDescriptorHelper.EmptySelection}: {@code -
     * none -}.
     * 
     * @return
     *     {@code - none -}
     */
    public static Localizable _DeploymentStepDescriptorHelper_EmptySelection() {
        return new Localizable(holder, "DeploymentStepDescriptorHelper.EmptySelection");
    }

}
