// CHECKSTYLE:OFF

package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code bitbucket.oauth.consumer.admin.menu}: {@code Manage
     * Bitbucket Server consumers}.
     * 
     * @return
     *     {@code Manage Bitbucket Server consumers}
     */
    public static String bitbucket_oauth_consumer_admin_menu() {
        return holder.format("bitbucket.oauth.consumer.admin.menu");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.menu}: {@code Manage
     * Bitbucket Server consumers}.
     * 
     * @return
     *     {@code Manage Bitbucket Server consumers}
     */
    public static Localizable _bitbucket_oauth_consumer_admin_menu() {
        return new Localizable(holder, "bitbucket.oauth.consumer.admin.menu");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.entry.form.error}: {@code There
     * was an error in creating the Bitbucket consumer. Details:}.
     * 
     * @return
     *     {@code There was an error in creating the Bitbucket consumer.
     *     Details:}
     */
    public static String bitbucket_oauth_consumer_entry_form_error() {
        return holder.format("bitbucket.oauth.consumer.entry.form.error");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.entry.form.error}: {@code There
     * was an error in creating the Bitbucket consumer. Details:}.
     * 
     * @return
     *     {@code There was an error in creating the Bitbucket consumer.
     *     Details:}
     */
    public static Localizable _bitbucket_oauth_consumer_entry_form_error() {
        return new Localizable(holder, "bitbucket.oauth.consumer.entry.form.error");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.update.description}: {@code
     * Edit Consumer Details}.
     * 
     * @return
     *     {@code Edit Consumer Details}
     */
    public static String bitbucket_oauth_consumer_admin_update_description() {
        return holder.format("bitbucket.oauth.consumer.admin.update.description");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.update.description}: {@code
     * Edit Consumer Details}.
     * 
     * @return
     *     {@code Edit Consumer Details}
     */
    public static Localizable _bitbucket_oauth_consumer_admin_update_description() {
        return new Localizable(holder, "bitbucket.oauth.consumer.admin.update.description");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.create.description}: {@code
     * Create New Consumer}.
     * 
     * @return
     *     {@code Create New Consumer}
     */
    public static String bitbucket_oauth_consumer_admin_create_description() {
        return holder.format("bitbucket.oauth.consumer.admin.create.description");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.create.description}: {@code
     * Create New Consumer}.
     * 
     * @return
     *     {@code Create New Consumer}
     */
    public static Localizable _bitbucket_oauth_consumer_admin_create_description() {
        return new Localizable(holder, "bitbucket.oauth.consumer.admin.create.description");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.menu.description}: {@code
     * Grant or revoke access to Jenkins by Bitbucket Server instances.}.
     * 
     * @return
     *     {@code Grant or revoke access to Jenkins by Bitbucket Server
     *     instances.}
     */
    public static String bitbucket_oauth_consumer_admin_menu_description() {
        return holder.format("bitbucket.oauth.consumer.admin.menu.description");
    }

    /**
     * Key {@code bitbucket.oauth.consumer.admin.menu.description}: {@code
     * Grant or revoke access to Jenkins by Bitbucket Server instances.}.
     * 
     * @return
     *     {@code Grant or revoke access to Jenkins by Bitbucket Server
     *     instances.}
     */
    public static Localizable _bitbucket_oauth_consumer_admin_menu_description() {
        return new Localizable(holder, "bitbucket.oauth.consumer.admin.menu.description");
    }

}
