// CHECKSTYLE:OFF

package com.atlassian.bitbucket.jenkins.internal.trigger;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BitbucketWebhookTriggerCause.withoutAuthor}: {@code
     * Triggered by Bitbucket Server webhook.}.
     * 
     * @return
     *     {@code Triggered by Bitbucket Server webhook.}
     */
    public static String BitbucketWebhookTriggerCause_withoutAuthor() {
        return holder.format("BitbucketWebhookTriggerCause.withoutAuthor");
    }

    /**
     * Key {@code BitbucketWebhookTriggerCause.withoutAuthor}: {@code
     * Triggered by Bitbucket Server webhook.}.
     * 
     * @return
     *     {@code Triggered by Bitbucket Server webhook.}
     */
    public static Localizable _BitbucketWebhookTriggerCause_withoutAuthor() {
        return new Localizable(holder, "BitbucketWebhookTriggerCause.withoutAuthor");
    }

    /**
     * Key {@code BitbucketWebhookTrigger.displayname}: {@code Bitbucket
     * webhook trigger}.
     * 
     * @return
     *     {@code Bitbucket webhook trigger}
     */
    public static String BitbucketWebhookTrigger_displayname() {
        return holder.format("BitbucketWebhookTrigger.displayname");
    }

    /**
     * Key {@code BitbucketWebhookTrigger.displayname}: {@code Bitbucket
     * webhook trigger}.
     * 
     * @return
     *     {@code Bitbucket webhook trigger}
     */
    public static Localizable _BitbucketWebhookTrigger_displayname() {
        return new Localizable(holder, "BitbucketWebhookTrigger.displayname");
    }

    /**
     * Key {@code BitbucketWebhookMultibranchTrigger.displayname}: {@code
     * Bitbucket webhook trigger}.
     * 
     * @return
     *     {@code Bitbucket webhook trigger}
     */
    public static String BitbucketWebhookMultibranchTrigger_displayname() {
        return holder.format("BitbucketWebhookMultibranchTrigger.displayname");
    }

    /**
     * Key {@code BitbucketWebhookMultibranchTrigger.displayname}: {@code
     * Bitbucket webhook trigger}.
     * 
     * @return
     *     {@code Bitbucket webhook trigger}
     */
    public static Localizable _BitbucketWebhookMultibranchTrigger_displayname() {
        return new Localizable(holder, "BitbucketWebhookMultibranchTrigger.displayname");
    }

    /**
     * Key {@code BitbucketWebhookTriggerCause.withAuthor}: {@code Triggered
     * by Bitbucket webhook due to changes by {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggered by Bitbucket webhook due to changes by {0}.}
     */
    public static String BitbucketWebhookTriggerCause_withAuthor(Object arg0) {
        return holder.format("BitbucketWebhookTriggerCause.withAuthor", arg0);
    }

    /**
     * Key {@code BitbucketWebhookTriggerCause.withAuthor}: {@code Triggered
     * by Bitbucket webhook due to changes by {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggered by Bitbucket webhook due to changes by {0}.}
     */
    public static Localizable _BitbucketWebhookTriggerCause_withAuthor(Object arg0) {
        return new Localizable(holder, "BitbucketWebhookTriggerCause.withAuthor", arg0);
    }

}
