/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.OAuthConverter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.OAuthRequestUtils;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.SecurityModeChecker;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.TrustedUnderlyingSystemAuthorizerFilter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.InvalidTokenException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.NoSuchUserException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.util.OAuthProblemUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.commons.lang3.StringUtils;

public class OAuth1aRequestFilter
implements Filter {
    private static final Logger log = Logger.getLogger(OAuth1aRequestFilter.class.getName());
    private final ServiceProviderConsumerStore consumerStore;
    private final ServiceProviderTokenStore tokenStore;
    private final OAuthValidator validator;
    private final Clock clock;
    private final TrustedUnderlyingSystemAuthorizerFilter authorizerFilter;
    private final SecurityModeChecker securityChecker;

    @Inject
    public OAuth1aRequestFilter(ServiceProviderConsumerStore consumerStore, ServiceProviderTokenStore tokenStore, OAuthValidator validator, Clock clock, TrustedUnderlyingSystemAuthorizerFilter authorizerFilter, SecurityModeChecker securityChecker) {
        this.consumerStore = consumerStore;
        this.tokenStore = tokenStore;
        this.validator = validator;
        this.clock = clock;
        this.authorizerFilter = authorizerFilter;
        this.securityChecker = securityChecker;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.securityChecker.isSecurityEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isOauthRequest(req)) {
            chain.doFilter(request, response);
            return;
        }
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)req, (String)this.getLogicalUri(req));
        String tokenStr = this.getTokenFromRequest(req, resp, message);
        if (tokenStr == null) {
            chain.doFilter(request, response);
            return;
        }
        try {
            user = this.verifyToken(message, tokenStr);
        }
        catch (OAuthProblemException ope) {
            this.handleOAuthProblemException(req, resp, message, ope);
            return;
        }
        catch (Exception ex) {
            this.handleException(req, resp, message, ex);
            return;
        }
        try {
            OAuthWWWAuthenticateAddingResponse oauthResp = new OAuthWWWAuthenticateAddingResponse(resp, OAuth1aRequestFilter.getBaseUrl(req));
            this.authorizerFilter.authorize(user, req, (HttpServletResponse)oauthResp, chain);
            OAuthProblemUtils.logOAuthRequest(req, "OAuth authentication successful. Request marked as OAuth.", log);
        }
        catch (NoSuchUserException exception) {
            String msg = String.format("User %s associated with the token %s not found in the system", user, tokenStr);
            OAuthServlet.handleException((HttpServletResponse)resp, (Exception)((Object)new OAuthProblemException(msg)), (String)OAuth1aRequestFilter.getBaseUrl(req));
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private String verifyToken(OAuthMessage message, String tokenStr) throws OAuthException, IOException, URISyntaxException {
        Optional<ServiceProviderToken> mayBeToken;
        try {
            mayBeToken = this.tokenStore.get(tokenStr);
        }
        catch (InvalidTokenException e) {
            log.log(Level.FINE, String.format("3-Legged-OAuth Consumer provided token [%s] rejected by ServiceProviderTokenStore", tokenStr), e);
            throw new OAuthProblemException("token_rejected");
        }
        if (!mayBeToken.isPresent()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], is null", tokenStr));
            }
            throw new OAuthProblemException("token_rejected");
        }
        ServiceProviderToken token = mayBeToken.get();
        if (!token.isAccessToken()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], is NOT an access token.", tokenStr));
            }
            throw new OAuthProblemException("token_rejected");
        }
        if (token.getUser() == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], does not have a corresponding user.", tokenStr));
            }
            throw new OAuthProblemException("No user associated with the token");
        }
        if (!token.getConsumer().getKey().equals(message.getConsumerKey())) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], consumer key [%s] does not match request consumer key [%s]", tokenStr, token.getConsumer().getKey(), message.getConsumerKey()));
            }
            throw new OAuthProblemException("token_rejected");
        }
        if (token.hasExpired(this.clock)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Token has expired. Token creation time [%d] time to live [%d] clock (contains logging delay) [%d]", token.getCreationTime(), token.getTimeToLive(), this.clock.millis()));
            }
            throw new OAuthProblemException("token_expired");
        }
        this.validate3LOMessage(message, token);
        this.validateConsumer(message);
        return token.getUser();
    }

    @CheckForNull
    private String getTokenFromRequest(HttpServletRequest request, HttpServletResponse response, OAuthMessage message) {
        try {
            return message.getToken();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "3-Legged-OAuth Failed to read token from request", e);
            this.sendError(request, response, 500, message);
            OAuthProblemUtils.logOAuthRequest(request, "OAuth authentication FAILED - Unreadable token", log);
            return null;
        }
    }

    private boolean isOauthRequest(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        return StringUtils.startsWithIgnoreCase((CharSequence)authorization, (CharSequence)"OAuth") && OAuthRequestUtils.isOAuthAccessAttempt(request);
    }

    private void printMessageToDebug(OAuthMessage message) throws IOException {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder("Validating incoming OAuth request:\n");
        sb.append("\turl: ").append(message.URL).append("\n");
        sb.append("\tmethod: ").append(message.method).append("\n");
        for (Map.Entry entry : message.getParameters()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        log.log(Level.FINE, sb.toString());
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, int status, OAuthMessage message) {
        response.setStatus(status);
        try {
            response.addHeader("WWW-Authenticate", message.getAuthorizationHeader(OAuth1aRequestFilter.getBaseUrl(request)));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failure reporting OAuth error to client", e);
        }
    }

    private Consumer validateConsumer(OAuthMessage message) throws IOException, OAuthException {
        String consumerKey = message.getConsumerKey();
        return this.consumerStore.get(consumerKey).orElseThrow(() -> {
            log.log(Level.INFO, "Unknown consumer key:'{}' supplied in OAuth request" + consumerKey);
            return new OAuthProblemException("consumer_key_unknown");
        });
    }

    private void handleOAuthProblemException(HttpServletRequest request, HttpServletResponse response, OAuthMessage message, OAuthProblemException ope) {
        OAuthProblemUtils.logOAuthProblem(message, ope, log);
        try {
            OAuthServlet.handleException((HttpServletResponse)response, (Exception)((Object)ope), (String)OAuth1aRequestFilter.getBaseUrl(request));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failure reporting OAuth error to client", e);
        }
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, OAuthMessage message, Exception e) {
        log.log(Level.SEVERE, "Failed to process OAuth message", e);
        this.sendError(request, response, 500, message);
    }

    @Nullable
    private String getLogicalUri(HttpServletRequest request) {
        String uriPathBeforeForwarding = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uriPathBeforeForwarding == null) {
            return null;
        }
        URI newUri = URI.create(request.getRequestURL().toString());
        try {
            return new URI(newUri.getScheme(), newUri.getAuthority(), uriPathBeforeForwarding, newUri.getQuery(), newUri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, "forwarded request had invalid original URI path: " + uriPathBeforeForwarding);
            return null;
        }
    }

    private void validate3LOMessage(OAuthMessage message, ServiceProviderToken token) throws OAuthException, IOException, URISyntaxException {
        this.printMessageToDebug(message);
        this.validator.validateMessage(message, OAuthConverter.createOAuthAccessor(token));
    }

    private static String getBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme() + "://";
        String serverName = request.getServerName();
        String serverPort = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
        String contextPath = request.getContextPath();
        return scheme + serverName + serverPort + contextPath;
    }

    public static final class OAuthWWWAuthenticateAddingResponse
    extends HttpServletResponseWrapper {
        private final String baseUrl;

        public OAuthWWWAuthenticateAddingResponse(HttpServletResponse response, String baseUrl) {
            super(response);
            this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        }

        public void sendError(int sc, String msg) throws IOException {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.sendError(sc);
        }

        public void setStatus(int sc, String sm) {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.setStatus(sc, sm);
        }

        public void setStatus(int sc) {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.setStatus(sc);
        }

        private void addOAuthAuthenticateHeader() {
            try {
                OAuthMessage message = new OAuthMessage(null, null, null);
                this.addHeader("WWW-Authenticate", message.getAuthorizationHeader(this.baseUrl));
            }
            catch (IOException e) {
                throw new RuntimeException("Somehow the OAuth.net library threw an IOException, even though it's not doing any IO operations", e);
            }
        }
    }
}

