/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketAuthenticatedUserClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.model.AtlassianServerCapabilities;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketResponse;
import java.util.List;
import java.util.Optional;
import okhttp3.HttpUrl;

public class BitbucketAuthenticatedUserClientImpl
implements BitbucketAuthenticatedUserClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;

    BitbucketAuthenticatedUserClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
    }

    @Override
    public Optional<String> getAuthenticatedUser() {
        HttpUrl url = this.bitbucketRequestExecutor.getBaseUrl().newBuilder().addPathSegment("rest").addPathSegment("capabilities").build();
        BitbucketResponse<AtlassianServerCapabilities> response = this.bitbucketRequestExecutor.makeGetRequest(url, AtlassianServerCapabilities.class, new RequestConfiguration[0]);
        List<String> usernames = response.getHeaders().get("X-AUSERNAME");
        if (usernames != null) {
            return usernames.stream().findFirst();
        }
        return Optional.empty();
    }
}

