/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketMissingCapabilityException;
import com.atlassian.bitbucket.jenkins.internal.client.supply.BitbucketCapabilitiesSupplier;
import com.atlassian.bitbucket.jenkins.internal.model.AtlassianServerCapabilities;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketCICapabilities;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhookSupportedEvents;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentCapabilities;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;

public class BitbucketCapabilitiesClientImpl
implements BitbucketCapabilitiesClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final Cache<HttpUrl, AtlassianServerCapabilities> capabilitiesCache;

    BitbucketCapabilitiesClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, Cache capabilitiesCache) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        this.capabilitiesCache = capabilitiesCache;
    }

    @Override
    public BitbucketCICapabilities getCICapabilities() {
        BitbucketCICapabilities ciCapabilities = this.getCapabilitiesForKey("build", BitbucketCICapabilities.class);
        if (ciCapabilities == null) {
            return new BitbucketCICapabilities(Collections.emptySet());
        }
        return ciCapabilities;
    }

    @Override
    public BitbucketDeploymentCapabilities getDeploymentCapabilities() {
        BitbucketDeploymentCapabilities deploymentCapabilities = this.getCapabilitiesForKey("deployment", BitbucketDeploymentCapabilities.class);
        if (deploymentCapabilities == null) {
            return new BitbucketDeploymentCapabilities(false);
        }
        return deploymentCapabilities;
    }

    @Override
    public AtlassianServerCapabilities getServerCapabilities() {
        try {
            return (AtlassianServerCapabilities)this.capabilitiesCache.get((Object)this.bitbucketRequestExecutor.getBaseUrl(), () -> new BitbucketCapabilitiesSupplier(this.bitbucketRequestExecutor).get());
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw (RuntimeException)uncheckedExecutionException.getCause();
        }
    }

    @Override
    public BitbucketWebhookSupportedEvents getWebhookSupportedEvents() throws BitbucketMissingCapabilityException {
        BitbucketWebhookSupportedEvents events = this.getCapabilitiesForKey("webhooks", BitbucketWebhookSupportedEvents.class);
        if (events == null) {
            throw new BitbucketMissingCapabilityException("Remote Bitbucket Server does not support Webhooks. Make sure Bitbucket server supports webhooks or correct version of it is installed.");
        }
        return events;
    }

    @Nullable
    private <T> T getCapabilitiesForKey(String key, Class<T> returnType) {
        AtlassianServerCapabilities capabilities = this.getServerCapabilities();
        String urlStr = capabilities.getCapabilities().get(key);
        if (urlStr == null) {
            return null;
        }
        HttpUrl url = HttpUrl.parse((String)urlStr);
        if (url == null) {
            throw new IllegalStateException("URL to fetch supported webhook supported event is wrong. URL: " + urlStr);
        }
        return this.bitbucketRequestExecutor.makeGetRequest(url, returnType, new RequestConfiguration[0]).getBody();
    }
}

