/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketMirrorClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirroredRepositoryDescriptor;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketMirrorClientImpl
implements BitbucketMirrorClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final int repositoryId;

    BitbucketMirrorClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, int repositoryId) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.repositoryId = repositoryId;
    }

    @Override
    public BitbucketPage<BitbucketMirroredRepositoryDescriptor> getMirroredRepositoryDescriptors() {
        HttpUrl url = this.bitbucketRequestExecutor.getBaseUrl().newBuilder().addPathSegment("rest").addPathSegment("mirroring").addPathSegment("1.0").addPathSegment("repos").addPathSegment(String.valueOf(this.repositoryId)).addPathSegment("mirrors").build();
        return this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketMirroredRepositoryDescriptor>>(){}, new RequestConfiguration[0]).getBody();
    }

    @Override
    public BitbucketMirroredRepository getRepositoryDetails(BitbucketMirroredRepositoryDescriptor repositoryDescriptor) {
        String repoUrl = repositoryDescriptor.getSelfLink();
        if (StringUtils.isEmpty((CharSequence)repoUrl)) {
            throw new BitbucketClientException("Empty Repo URL");
        }
        HttpUrl mirrorUrl = HttpUrl.parse((String)repoUrl);
        if (mirrorUrl == null) {
            throw new BitbucketClientException("Invalid repo URL " + repoUrl);
        }
        return this.bitbucketRequestExecutor.makeGetRequest(mirrorUrl, BitbucketMirroredRepository.class, new RequestConfiguration[0]).getBody();
    }
}

