/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBranchClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBranchClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBuildStatusClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBuildStatusClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketDeploymentClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketDeploymentClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRepositoryClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.ModernBitbucketBuildStatusClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.client.paging.BitbucketPageStreamUtil;
import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketCICapabilities;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketDefaultBranch;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequest;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequestState;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.provider.InstanceKeyPairProvider;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.fasterxml.jackson.core.type.TypeReference;
import hudson.model.TaskListener;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class BitbucketRepositoryClientImpl
implements BitbucketRepositoryClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final BitbucketCapabilitiesClient capabilitiesClient;
    private final String projectKey;
    private final String repositorySlug;

    BitbucketRepositoryClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, BitbucketCapabilitiesClient capabilitiesClient, String projectKey, String repositorySlug) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.capabilitiesClient = capabilitiesClient;
        this.projectKey = Objects.requireNonNull(StringUtils.stripToNull((String)projectKey), "projectKey");
        this.repositorySlug = Objects.requireNonNull(StringUtils.stripToNull((String)repositorySlug), "repositorySlug");
    }

    public BitbucketBuildStatusClient getBuildStatusClient(String revisionSha, BitbucketSCMRepository bitbucketSCMRepo, BitbucketCICapabilities ciCapabilities, InstanceKeyPairProvider instanceKeyPairProvider, DisplayURLProvider displayURLProvider) {
        if (ciCapabilities.supportsRichBuildStatus()) {
            return new ModernBitbucketBuildStatusClientImpl(this.bitbucketRequestExecutor, bitbucketSCMRepo.getProjectKey(), bitbucketSCMRepo.getRepositorySlug(), revisionSha, instanceKeyPairProvider, displayURLProvider, ciCapabilities.supportsCancelledBuildStates());
        }
        return new BitbucketBuildStatusClientImpl(this.bitbucketRequestExecutor, revisionSha);
    }

    @Override
    public BitbucketBranchClient getBranchClient(TaskListener taskListener) {
        return new BitbucketBranchClientImpl(this.bitbucketRequestExecutor, this.projectKey, this.repositorySlug, taskListener);
    }

    @Override
    public BitbucketBuildStatusClient getBuildStatusClient(String revisionSha) {
        BitbucketCICapabilities ciCapabilities = this.capabilitiesClient.getCICapabilities();
        if (ciCapabilities.supportsRichBuildStatus()) {
            return new ModernBitbucketBuildStatusClientImpl(this.bitbucketRequestExecutor, this.projectKey, this.repositorySlug, revisionSha, ciCapabilities.supportsCancelledBuildStates());
        }
        return new BitbucketBuildStatusClientImpl(this.bitbucketRequestExecutor, revisionSha);
    }

    @Override
    public BitbucketDeploymentClient getDeploymentClient(String revisionSha) {
        return new BitbucketDeploymentClientImpl(this.bitbucketRequestExecutor, this.projectKey, this.repositorySlug, revisionSha);
    }

    @Override
    public BitbucketFilePathClient getFilePathClient() {
        return new BitbucketFilePathClientImpl(this.bitbucketRequestExecutor, this.projectKey, this.repositorySlug);
    }

    @Override
    public Stream<BitbucketPullRequest> getPullRequests(BitbucketPullRequestState state) {
        return this.getPullRequestsWithState(state.toString());
    }

    @Override
    public Stream<BitbucketPullRequest> getPullRequests() {
        return this.getPullRequestsWithState("ALL");
    }

    @Override
    public BitbucketRepository getRepository() {
        return this.bitbucketRequestExecutor.makeGetRequest(this.getRepositoryUrl().build(), BitbucketRepository.class, new RequestConfiguration[0]).getBody();
    }

    @Override
    public BitbucketWebhookClient getWebhookClient() {
        return new BitbucketWebhookClientImpl(this.bitbucketRequestExecutor, this.projectKey, this.repositorySlug);
    }

    @Override
    public BitbucketDefaultBranch getDefaultBranch() {
        return this.bitbucketRequestExecutor.makeGetRequest(this.getDefaultBranchyUrl().build(), BitbucketDefaultBranch.class, new RequestConfiguration[0]).getBody();
    }

    private Stream<BitbucketPullRequest> getBitbucketPullRequestStream(HttpUrl.Builder urlBuilder) {
        HttpUrl url = urlBuilder.build();
        BitbucketPage<BitbucketPullRequest> firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketPullRequest>>(){}, new RequestConfiguration[0]).getBody();
        return BitbucketPageStreamUtil.toStream(firstPage, new NextPageFetcherImpl(url, this.bitbucketRequestExecutor)).map(BitbucketPage::getValues).flatMap(Collection::stream);
    }

    private Stream<BitbucketPullRequest> getPullRequestsWithState(String stateQuery) {
        return this.getBitbucketPullRequestStream(this.getRepositoryUrl().addPathSegment("pull-requests").addQueryParameter("withAttributes", "false").addQueryParameter("withProperties", "false").addQueryParameter("state", stateQuery));
    }

    private HttpUrl.Builder getRepositoryUrl() {
        return this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug);
    }

    private HttpUrl.Builder getDefaultBranchyUrl() {
        return this.getRepositoryUrl().addPathSegment("default-branch");
    }

    static class NextPageFetcherImpl
    implements NextPageFetcher<BitbucketPullRequest> {
        private final BitbucketRequestExecutor bitbucketRequestExecutor;
        private final HttpUrl url;

        NextPageFetcherImpl(HttpUrl url, BitbucketRequestExecutor bitbucketRequestExecutor) {
            this.url = url;
            this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        }

        @Override
        public BitbucketPage<BitbucketPullRequest> next(BitbucketPage<BitbucketPullRequest> previous) {
            if (previous.isLastPage()) {
                throw new IllegalArgumentException("Last page does not have next page");
            }
            return this.bitbucketRequestExecutor.makeGetRequest(this.nextPageUrl(previous), new TypeReference<BitbucketPage<BitbucketPullRequest>>(){}, new RequestConfiguration[0]).getBody();
        }

        private HttpUrl nextPageUrl(BitbucketPage<BitbucketPullRequest> previous) {
            return this.url.newBuilder().addQueryParameter("start", String.valueOf(previous.getNextPageStart())).build();
        }
    }
}

