/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.deployments.Messages;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironmentType;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.inject.Singleton;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class DeploymentStepDescriptorHelper {
    private static final FormValidation FORM_VALIDATION_OK = FormValidation.ok();
    private static final int ENVIRONMENT_NAME_MAX = 255;
    private static final int ENVIRONMENT_URL_MAX = 1024;
    private static final int ENVIRONMENT_KEY_MAX = 255;
    @Inject
    private JenkinsProvider jenkinsProvider;

    public FormValidation doCheckEnvironmentKey(@CheckForNull Item context, @CheckForNull String environmentKey) {
        this.checkPermissions(context);
        if (StringUtils.isBlank((CharSequence)environmentKey)) {
            return FORM_VALIDATION_OK;
        }
        if (environmentKey.length() > 255) {
            return FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_KeyTooLong());
        }
        return FORM_VALIDATION_OK;
    }

    public FormValidation doCheckEnvironmentName(@CheckForNull Item context, @CheckForNull String environmentName) {
        this.checkPermissions(context);
        if (StringUtils.isBlank((CharSequence)environmentName)) {
            return FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_EnvironmentNameRequired());
        }
        if (environmentName.length() > 255) {
            return FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_EnvironmentNameTooLong());
        }
        return FORM_VALIDATION_OK;
    }

    public FormValidation doCheckEnvironmentType(@CheckForNull Item context, @CheckForNull String environmentType) {
        this.checkPermissions(context);
        if (StringUtils.isBlank((CharSequence)environmentType)) {
            return FORM_VALIDATION_OK;
        }
        return BitbucketDeploymentEnvironmentType.fromName(environmentType).map(validType -> FORM_VALIDATION_OK).orElseGet(() -> FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_EnvironmentTypeInvalid()));
    }

    public FormValidation doCheckEnvironmentUrl(@CheckForNull Item context, @CheckForNull String environmentUrl) {
        this.checkPermissions(context);
        if (StringUtils.isBlank((CharSequence)environmentUrl)) {
            return FORM_VALIDATION_OK;
        }
        try {
            URI uri = new URI(environmentUrl);
            if (!uri.isAbsolute()) {
                return FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_UriAbsolute());
            }
            if (environmentUrl.length() > 1024) {
                return FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_UriTooLong());
            }
            return FORM_VALIDATION_OK;
        }
        catch (URISyntaxException e) {
            return FormValidation.error((String)Messages.DeploymentStepDescriptorHelper_EnvironmentUrlInvalid());
        }
    }

    public ListBoxModel doFillEnvironmentTypeItems(@CheckForNull Item context) {
        this.checkPermissions(context);
        ListBoxModel options = new ListBoxModel();
        options.add(Messages.DeploymentStepDescriptorHelper_EmptySelection(), "");
        Arrays.stream(BitbucketDeploymentEnvironmentType.values()).sorted(Comparator.comparingInt(BitbucketDeploymentEnvironmentType::getWeight)).forEach(v -> options.add(v.getDisplayName(), v.name()));
        return options;
    }

    private void checkPermissions(@CheckForNull Item context) {
        if (context != null) {
            context.checkPermission(Item.EXTENDED_READ);
        } else {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
        }
    }
}

